
package ru.yandex.qatools.allure.model;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for status.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="status"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="failed"/&gt;
 *     &lt;enumeration value="broken"/&gt;
 *     &lt;enumeration value="passed"/&gt;
 *     &lt;enumeration value="skipped"/&gt;
 *     &lt;enumeration value="canceled"/&gt;
 *     &lt;enumeration value="pending"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "status")
@XmlEnum
public enum Status {

    @XmlEnumValue("failed")
    FAILED("failed"),
    @XmlEnumValue("broken")
    BROKEN("broken"),
    @XmlEnumValue("passed")
    PASSED("passed"),

    /**
     * This is Deprecated. Use canceled status instead.
     * 
     */
    @XmlEnumValue("skipped")
    SKIPPED("skipped"),
    @XmlEnumValue("canceled")
    CANCELED("canceled"),
    @XmlEnumValue("pending")
    PENDING("pending");
    private final String value;

    Status(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static Status fromValue(String v) {
        for (Status c: Status.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
