/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples;

import alluxio.AlluxioURI;
import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicNonByteBufferOperations
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicNonByteBufferOperations.class);
    private final AlluxioURI mFilePath;
    private final ReadType mReadType;
    private final WriteType mWriteType;
    private final boolean mDeleteIfExists;
    private final int mLength;
    private final FileSystemContext mFsContext;

    public BasicNonByteBufferOperations(AlluxioURI filePath, ReadType readType, WriteType writeType, boolean deleteIfExists, int length, FileSystemContext fsContext) {
        this.mFilePath = filePath;
        this.mWriteType = writeType;
        this.mReadType = readType;
        this.mDeleteIfExists = deleteIfExists;
        this.mLength = length;
        this.mFsContext = fsContext;
    }

    @Override
    public Boolean call() throws Exception {
        FileSystem alluxioClient = FileSystem.Factory.create((FileSystemContext)this.mFsContext);
        this.write(alluxioClient);
        return this.read(alluxioClient);
    }

    private void write(FileSystem alluxioClient) throws IOException, AlluxioException {
        FileOutStream fileOutStream = this.createFile(alluxioClient, this.mFilePath, this.mDeleteIfExists);
        long startTimeMs = CommonUtils.getCurrentMs();
        try (DataOutputStream os = new DataOutputStream((OutputStream)fileOutStream);){
            os.writeInt(this.mLength);
            for (int i = 0; i < this.mLength; ++i) {
                os.writeInt(i);
            }
        }
        LOG.info(FormatUtils.formatTimeTakenMs((long)startTimeMs, (String)("writeFile to file " + this.mFilePath)));
    }

    private FileOutStream createFile(FileSystem fileSystem, AlluxioURI filePath, boolean deleteIfExists) throws IOException, AlluxioException {
        CreateFilePOptions options = CreateFilePOptions.newBuilder().setWriteType(this.mWriteType.toProto()).setRecursive(true).build();
        if (!fileSystem.exists(filePath)) {
            return fileSystem.createFile(filePath, options);
        }
        if (deleteIfExists) {
            fileSystem.delete(filePath);
            return fileSystem.createFile(filePath, options);
        }
        throw new FileAlreadyExistsException("File exists and deleteIfExists is false");
    }

    private boolean read(FileSystem alluxioClient) throws IOException, AlluxioException {
        OpenFilePOptions options = OpenFilePOptions.newBuilder().setReadType(this.mReadType.toProto()).build();
        boolean pass = true;
        long startTimeMs = CommonUtils.getCurrentMs();
        try (DataInputStream input = new DataInputStream((InputStream)alluxioClient.openFile(this.mFilePath, options));){
            int length = input.readInt();
            for (int i = 0; i < length; ++i) {
                if (input.readInt() == i) continue;
                pass = false;
                break;
            }
        }
        LOG.info(FormatUtils.formatTimeTakenMs((long)startTimeMs, (String)("readFile file " + this.mFilePath)));
        return pass;
    }
}

