/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.util.ConfigurationUtils;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public final class MultiMount {
    private MultiMount() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: ./bin/alluxio runClass alluxio.examples.MultiMount <HDFS_URL>");
            System.exit(-1);
        }
        InstancedConfiguration alluxioConf = new InstancedConfiguration(ConfigurationUtils.defaults());
        AlluxioURI mntPath = new AlluxioURI("/mnt");
        AlluxioURI s3Mount = new AlluxioURI("/mnt/s3");
        AlluxioURI inputPath = new AlluxioURI("/mnt/s3/hello.txt");
        AlluxioURI s3Path = new AlluxioURI("s3a://alluxio-demo/");
        AlluxioURI hdfsMount = new AlluxioURI("/mnt/hdfs");
        AlluxioURI outputPath = new AlluxioURI("/mnt/hdfs/hello.txt");
        AlluxioURI hdfsPath = new AlluxioURI(args[0]);
        FileSystem fileSystem = FileSystem.Factory.create((AlluxioConfiguration)alluxioConf);
        try {
            if (!fileSystem.exists(mntPath)) {
                System.out.print("creating " + mntPath + " ... ");
                fileSystem.createDirectory(mntPath);
                System.out.println("done");
            }
            if (fileSystem.exists(s3Mount)) {
                System.out.print("unmounting " + s3Mount + " ... ");
                fileSystem.unmount(s3Mount);
                System.out.println("done");
            }
            if (fileSystem.exists(hdfsMount)) {
                System.out.print("unmounting " + hdfsMount + " ... ");
                fileSystem.unmount(hdfsMount);
                System.out.println("done");
            }
            System.out.print("mounting " + s3Path + " to " + s3Mount + " ... ");
            fileSystem.mount(s3Mount, s3Path);
            System.out.println("done");
            System.out.print("mounting " + hdfsPath + " to " + hdfsMount + " ... ");
            fileSystem.mount(hdfsMount, hdfsPath);
            System.out.println("done");
            if (fileSystem.exists(outputPath)) {
                System.out.print("deleting " + outputPath + " ... ");
                fileSystem.delete(outputPath);
                System.out.println("done");
            }
            System.out.print("opening " + inputPath + " ... ");
            FileInStream is = fileSystem.openFile(inputPath);
            System.out.println("done");
            System.out.print("opening " + outputPath + " ... ");
            CreateFilePOptions options = CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setRecursive(true).build();
            FileOutStream os = fileSystem.createFile(outputPath, options);
            System.out.println("done");
            System.out.print("transferring data from " + inputPath + " to " + outputPath + " ... ");
            IOUtils.copy((InputStream)is, (OutputStream)os);
            System.out.println("done");
            System.out.print("closing " + inputPath + " ... ");
            is.close();
            System.out.println("done");
            System.out.print("closing " + outputPath + " ... ");
            os.close();
            System.out.println("done");
        }
        catch (Exception e) {
            System.out.println("fail");
            e.printStackTrace();
        }
        finally {
            try {
                if (fileSystem.exists(s3Mount)) {
                    System.out.print("unmounting " + s3Mount + " ... ");
                    fileSystem.unmount(s3Mount);
                    System.out.println("done");
                }
            }
            catch (Exception e) {
                System.out.println("fail");
                e.printStackTrace();
            }
            try {
                if (fileSystem.exists(hdfsMount)) {
                    System.out.print("unmounting " + hdfsMount + " ... ");
                    fileSystem.unmount(hdfsMount);
                    System.out.println("done");
                }
            }
            catch (Exception e) {
                System.out.println("fail");
                e.printStackTrace();
            }
        }
    }
}

