/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse;

import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.options.FileSystemOptions;
import alluxio.client.file.options.UfsFileSystemOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.exception.runtime.FailedPreconditionRuntimeException;
import alluxio.exception.runtime.InvalidArgumentRuntimeException;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.AlluxioJniFuseFileSystem;
import alluxio.fuse.AlluxioJnrFuseFileSystem;
import alluxio.fuse.FuseSignalHandler;
import alluxio.fuse.FuseUmountable;
import alluxio.fuse.FuseWebServer;
import alluxio.fuse.meta.UpdateChecker;
import alluxio.fuse.options.FuseOptions;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatThread;
import alluxio.jnifuse.LibFuse;
import alluxio.jnifuse.utils.LibfuseVersion;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.security.user.UserState;
import alluxio.util.CommonUtils;
import alluxio.util.JvmPauseMonitor;
import alluxio.util.network.NetworkAddressUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;

@ThreadSafe
public final class AlluxioFuse {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioFuse.class);
    private static final CommandLineParser PARSER = new DefaultParser();
    private static final String MOUNT_POINT_OPTION_NAME = "m";
    private static final String MOUNT_ALLUXIO_PATH_OPTION_NAME = "a";
    private static final String MOUNT_ROOT_UFS_OPTION_NAME = "u";
    private static final String MOUNT_OPTIONS_OPTION_NAME = "o";
    private static final String HELP_OPTION_NAME = "h";
    private static final String UPDATE_CHECK_OPTION_NAME = "c";
    private static final Option MOUNT_POINT_OPTION = Option.builder((String)"m").hasArg().required(false).longOpt("mount-point").desc("The absolute local filesystem path that standalone Fuse will mount Alluxio path to.").build();
    private static final Option MOUNT_ALLUXIO_PATH_OPTION = Option.builder((String)"a").hasArg().required(false).longOpt("alluxio-path").desc("The Alluxio path to mount to the given Fuse mount point (for example, mount alluxio path `/alluxio` to fuse mount point `/mnt/alluxio-fuse`; local operations like `mkdir /mnt/alluxio-fuse/folder` will be translated to `alluxio fs mkdir /alluxio/folder`)").build();
    private static final Option MOUNT_ROOT_UFS_OPTION = Option.builder((String)"u").hasArg().required(false).longOpt("root-ufs").desc("The storage address of the UFS to mount to the given Fuse mount point. All operations against the FUSE mount point will be redirected to this storage address. (for example, mount storage address `s3://my_bucket/my_folder` to local FUSE mount point `/mnt/alluxio-fuse`; local operations like `mkdir /mnt/alluxio-fuse/folder` will be translated to `mkdir s3://my_bucket/my_folder/folder`)").build();
    private static final Option MOUNT_OPTIONS = Option.builder((String)"o").valueSeparator(',').required(false).hasArgs().desc("Providing mount options separating by comma. Mount options includes operating system mount options, many FUSE specific mount options (e.g. direct_io,attr_timeout=10s.allow_other), Alluxio property key=value pairs, and Alluxio FUSE special mount options data_cache=<local_cache_directory>,data_cache_size=<size>,metadata_cache_size=<size>,metadata_cache_expire=<timeout>").build();
    private static final Option UPDATE_CHECK_OPTION = Option.builder((String)"c").required(false).longOpt("update-check").hasArg().desc("Enables or disables the FUSE version update check. Disabled by default when connecting to Alluxio system cache. Enabled by default when connecting an under storage directly.").build();
    private static final Option HELP_OPTION = Option.builder((String)"h").required(false).desc("Print this help message").build();
    private static final Options OPTIONS = new Options().addOption(MOUNT_POINT_OPTION).addOption(MOUNT_ALLUXIO_PATH_OPTION).addOption(MOUNT_ROOT_UFS_OPTION).addOption(MOUNT_OPTIONS).addOption(UPDATE_CHECK_OPTION).addOption(HELP_OPTION);

    private AlluxioFuse() {
    }

    public static void main(String[] args) throws ParseException {
        CommandLine cli = PARSER.parse(OPTIONS, args);
        if (cli.hasOption(HELP_OPTION_NAME)) {
            HelpFormatter fmt = new HelpFormatter();
            fmt.printHelp(AlluxioFuse.class.getName(), OPTIONS);
            return;
        }
        LOG.info("Alluxio version: {}-{}", (Object)"2.9.3", (Object)"9eae6eff2c3f553ed4e68373958288291edf97e3");
        AlluxioFuse.setConfigurationFromInput(cli, Configuration.modifiableGlobal());
        AlluxioConfiguration conf = Configuration.global();
        FuseOptions fuseOptions = AlluxioFuse.getFuseOptions(cli, conf);
        FileSystemContext fsContext = FileSystemContext.create((AlluxioConfiguration)conf);
        if (!fuseOptions.getFileSystemOptions().getUfsFileSystemOptions().isPresent()) {
            conf = AlluxioFuseUtils.tryLoadingConfigFromMaster(fsContext);
        }
        CommonUtils.PROCESS_TYPE.set(CommonUtils.ProcessType.CLIENT);
        MetricsSystem.startSinks((String)conf.getString(PropertyKey.METRICS_CONF_FILE));
        if (conf.getBoolean(PropertyKey.FUSE_WEB_ENABLED)) {
            FuseWebServer webServer = new FuseWebServer(NetworkAddressUtils.ServiceType.FUSE_WEB.getServiceName(), NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.FUSE_WEB, (AlluxioConfiguration)Configuration.global()));
            webServer.start();
        }
        AlluxioFuse.startJvmMonitorProcess();
        ExecutorService executor = null;
        if (fuseOptions.updateCheckEnabled()) {
            executor = Executors.newSingleThreadExecutor();
            executor.submit((Runnable)new HeartbeatThread("Fuse update check", (HeartbeatExecutor)UpdateChecker.create(fuseOptions), () -> 86400000L, Configuration.global(), UserState.Factory.create((AlluxioConfiguration)conf)));
        }
        try (FileSystem fs = FileSystem.Factory.create((FileSystemContext)fsContext, (FileSystemOptions)fuseOptions.getFileSystemOptions());){
            AlluxioFuse.launchFuse(fsContext, fs, fuseOptions, true);
        }
        catch (Throwable t) {
            if (executor != null) {
                executor.shutdown();
            }
            LOG.error("Failed to launch FUSE", t);
            System.exit(-1);
        }
    }

    public static FuseUmountable launchFuse(FileSystemContext fsContext, FileSystem fs, FuseOptions fuseOptions, boolean blocking) {
        AlluxioConfiguration conf = fsContext.getClusterConf();
        AlluxioFuse.validateFuseConfAndOptions(conf, fuseOptions);
        LibFuse.loadLibrary((LibfuseVersion)AlluxioFuseUtils.getLibfuseVersion(conf));
        String mountPoint = conf.getString(PropertyKey.FUSE_MOUNT_POINT);
        Path mountPath = Paths.get(mountPoint, new String[0]);
        if (!Files.exists(mountPath, new LinkOption[0])) {
            LOG.warn("Mount point on local filesystem does not exist, creating {}", (Object)mountPoint);
            try {
                Files.createDirectories(mountPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new FailedPreconditionRuntimeException("Failed to create mount point");
            }
        }
        boolean debugEnabled = conf.getBoolean(PropertyKey.FUSE_DEBUG_ENABLED);
        if (conf.getBoolean(PropertyKey.FUSE_JNIFUSE_ENABLED)) {
            AlluxioJniFuseFileSystem fuseFs = new AlluxioJniFuseFileSystem(fsContext, fs, fuseOptions);
            FuseSignalHandler fuseSignalHandler = new FuseSignalHandler(fuseFs);
            Signal.handle(new Signal("TERM"), fuseSignalHandler);
            try {
                LOG.info("Mounting AlluxioJniFuseFileSystem: mount point=\"{}\", OPTIONS=\"{}\"", (Object)mountPoint, (Object)String.join((CharSequence)",", fuseOptions.getFuseMountOptions()));
                fuseFs.mount(blocking, debugEnabled, fuseOptions.getFuseMountOptions());
                return fuseFs;
            }
            catch (RuntimeException e) {
                fuseFs.umount(true);
                throw e;
            }
        }
        AlluxioJnrFuseFileSystem fuseFs = new AlluxioJnrFuseFileSystem(fs, conf, fuseOptions);
        try {
            fuseFs.mount(mountPath, blocking, debugEnabled, (String[])fuseOptions.getFuseMountOptions().stream().map(a -> "-o" + a).toArray(String[]::new));
            return fuseFs;
        }
        catch (Throwable t) {
            fuseFs.umount();
            throw t;
        }
    }

    private static void setConfigurationFromInput(CommandLine cli, InstancedConfiguration conf) {
        if (cli.hasOption(MOUNT_POINT_OPTION_NAME)) {
            conf.set(PropertyKey.FUSE_MOUNT_POINT, (Object)cli.getOptionValue(MOUNT_POINT_OPTION_NAME), Source.RUNTIME);
        }
        if (cli.hasOption(MOUNT_ALLUXIO_PATH_OPTION_NAME)) {
            conf.set(PropertyKey.FUSE_MOUNT_ALLUXIO_PATH, (Object)cli.getOptionValue(MOUNT_ALLUXIO_PATH_OPTION_NAME), Source.RUNTIME);
        }
        if (cli.hasOption(MOUNT_ROOT_UFS_OPTION_NAME)) {
            conf.set(PropertyKey.USER_METRICS_COLLECTION_ENABLED, (Object)false, Source.RUNTIME);
            conf.set(PropertyKey.USER_UPDATE_FILE_ACCESSTIME_DISABLED, (Object)true, Source.RUNTIME);
        }
        if (cli.hasOption(MOUNT_OPTIONS_OPTION_NAME)) {
            String[] mountOptionsArray;
            ArrayList<String> fuseOptions = new ArrayList<String>();
            for (String opt : mountOptionsArray = cli.getOptionValues(MOUNT_OPTIONS_OPTION_NAME)) {
                String trimedOpt = opt.trim();
                if (trimedOpt.isEmpty()) continue;
                String[] optArray = trimedOpt.split("=");
                if (optArray.length == 1) {
                    fuseOptions.add(trimedOpt);
                    continue;
                }
                String key = optArray[0];
                String value = optArray[1];
                if (PropertyKey.isValid((String)key)) {
                    PropertyKey propertyKey = PropertyKey.fromString((String)key);
                    conf.set(propertyKey, propertyKey.parseValue(value), Source.RUNTIME);
                    LOG.info("Set Alluxio property key({}={}) from command line input", (Object)key, (Object)value);
                    continue;
                }
                if (key.equals("data_cache")) {
                    conf.set(PropertyKey.USER_CLIENT_CACHE_ENABLED, (Object)true, Source.RUNTIME);
                    conf.set(PropertyKey.USER_CLIENT_CACHE_DIRS, PropertyKey.USER_CLIENT_CACHE_DIRS.parseValue(value), Source.RUNTIME);
                    LOG.info("Set data cache to {} from command line input", (Object)value);
                    continue;
                }
                if (key.equals("data_cache_size")) {
                    conf.set(PropertyKey.USER_CLIENT_CACHE_SIZE, PropertyKey.USER_CLIENT_CACHE_SIZE.parseValue(value), Source.RUNTIME);
                    LOG.info("Set data cache size as {} from command line input", (Object)value);
                    continue;
                }
                if (key.equals("metadata_cache_size")) {
                    if (value.equals("0")) continue;
                    conf.set(PropertyKey.USER_METADATA_CACHE_ENABLED, (Object)true, Source.RUNTIME);
                    conf.set(PropertyKey.USER_METADATA_CACHE_MAX_SIZE, PropertyKey.USER_METADATA_CACHE_MAX_SIZE.parseValue(value), Source.RUNTIME);
                    LOG.info("Set metadata cache size as {} from command line input", (Object)value);
                    continue;
                }
                if (key.equals("metadata_cache_expire")) {
                    conf.set(PropertyKey.USER_METADATA_CACHE_EXPIRATION_TIME, PropertyKey.USER_METADATA_CACHE_EXPIRATION_TIME.parseValue(value), Source.RUNTIME);
                    LOG.info("Set metadata cache expiration time as {} from command line input", (Object)value);
                    continue;
                }
                fuseOptions.add(trimedOpt);
            }
            if (!fuseOptions.isEmpty()) {
                conf.set(PropertyKey.FUSE_MOUNT_OPTIONS, fuseOptions, Source.RUNTIME);
                LOG.info("Set fuse mount point options as {} from command line input", (Object)String.join((CharSequence)",", fuseOptions));
            }
        }
    }

    private static FuseOptions getFuseOptions(CommandLine cli, AlluxioConfiguration conf) {
        boolean updateCheckEnabled = false;
        if (cli.hasOption(UPDATE_CHECK_OPTION_NAME)) {
            updateCheckEnabled = Boolean.parseBoolean(cli.getOptionValue(UPDATE_CHECK_OPTION_NAME));
        } else if (cli.hasOption(MOUNT_ROOT_UFS_OPTION_NAME)) {
            updateCheckEnabled = true;
        }
        return cli.hasOption(MOUNT_ROOT_UFS_OPTION_NAME) ? FuseOptions.create(conf, FileSystemOptions.create((AlluxioConfiguration)conf, Optional.of(new UfsFileSystemOptions(cli.getOptionValue(MOUNT_ROOT_UFS_OPTION_NAME)))), updateCheckEnabled) : FuseOptions.create(conf, updateCheckEnabled);
    }

    private static void validateFuseConfAndOptions(AlluxioConfiguration conf, FuseOptions options) {
        String mountPoint = conf.getString(PropertyKey.FUSE_MOUNT_POINT);
        if (mountPoint.isEmpty()) {
            throw new InvalidArgumentRuntimeException(String.format("%s should be set and should not be empty", PropertyKey.FUSE_MOUNT_POINT.getName()));
        }
        if (!options.getFileSystemOptions().getUfsFileSystemOptions().isPresent() && conf.getString(PropertyKey.FUSE_MOUNT_ALLUXIO_PATH).isEmpty()) {
            throw new InvalidArgumentRuntimeException(String.format("%s should be set and should not be empty", PropertyKey.FUSE_MOUNT_ALLUXIO_PATH.getName()));
        }
        if (Files.isRegularFile(Paths.get(mountPoint, new String[0]), new LinkOption[0])) {
            LOG.error("Mount point {} is not a directory but a file", (Object)mountPoint);
            throw new InvalidArgumentRuntimeException("Failed to launch fuse, mount point is a file");
        }
    }

    private static void startJvmMonitorProcess() {
        if (Configuration.getBoolean((PropertyKey)PropertyKey.STANDALONE_FUSE_JVM_MONITOR_ENABLED)) {
            JvmPauseMonitor jvmPauseMonitor = new JvmPauseMonitor(Configuration.getMs((PropertyKey)PropertyKey.JVM_MONITOR_SLEEP_INTERVAL_MS), Configuration.getMs((PropertyKey)PropertyKey.JVM_MONITOR_WARN_THRESHOLD_MS), Configuration.getMs((PropertyKey)PropertyKey.JVM_MONITOR_INFO_THRESHOLD_MS));
            jvmPauseMonitor.start();
            MetricsSystem.registerGaugeIfAbsent((String)MetricsSystem.getMetricName((String)MetricKey.TOTAL_EXTRA_TIME.getName()), () -> ((JvmPauseMonitor)jvmPauseMonitor).getTotalExtraTime());
            MetricsSystem.registerGaugeIfAbsent((String)MetricsSystem.getMetricName((String)MetricKey.INFO_TIME_EXCEEDED.getName()), () -> ((JvmPauseMonitor)jvmPauseMonitor).getInfoTimeExceeded());
            MetricsSystem.registerGaugeIfAbsent((String)MetricsSystem.getMetricName((String)MetricKey.WARN_TIME_EXCEEDED.getName()), () -> ((JvmPauseMonitor)jvmPauseMonitor).getWarnTimeExceeded());
        }
    }
}

