/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse;

import alluxio.AlluxioURI;
import alluxio.cli.FuseShell;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.collections.IndexDefinition;
import alluxio.collections.IndexedSet;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.exception.runtime.AlreadyExistsRuntimeException;
import alluxio.exception.runtime.CancelledRuntimeException;
import alluxio.exception.runtime.DeadlineExceededRuntimeException;
import alluxio.exception.runtime.NotFoundRuntimeException;
import alluxio.exception.runtime.UnimplementedRuntimeException;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.AlluxioJniRenameUtils;
import alluxio.fuse.FuseUmountable;
import alluxio.fuse.auth.AuthPolicy;
import alluxio.fuse.auth.AuthPolicyFactory;
import alluxio.fuse.file.CreateFileStatus;
import alluxio.fuse.file.FileStatus;
import alluxio.fuse.file.FuseFileEntry;
import alluxio.fuse.file.FuseFileStream;
import alluxio.fuse.options.FuseOptions;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.ErrorType;
import alluxio.grpc.SetAttributePOptions;
import alluxio.jnifuse.AbstractFuseFileSystem;
import alluxio.jnifuse.ErrorCodes;
import alluxio.jnifuse.FuseFileSystem;
import alluxio.jnifuse.FuseFillDir;
import alluxio.jnifuse.struct.FileStat;
import alluxio.jnifuse.struct.FuseFileInfo;
import alluxio.jnifuse.struct.Statvfs;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.resource.CloseableResource;
import alluxio.security.authorization.Mode;
import alluxio.util.CommonUtils;
import alluxio.util.LogUtils;
import alluxio.util.WaitForOptions;
import alluxio.wire.BlockMasterInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.cache.LoadingCache;
import com.google.protobuf.Any;
import io.grpc.Status;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import jnr.constants.platform.OpenFlags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@ThreadSafe
public final class AlluxioJniFuseFileSystem
extends AbstractFuseFileSystem
implements FuseUmountable {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioJniFuseFileSystem.class);
    private final AlluxioConfiguration mConf;
    private final FileSystem mFileSystem;
    private final FileSystemContext mFileSystemContext;
    private final Supplier<BlockMasterInfo> mFsStatCache;
    private final LoadingCache<String, AlluxioURI> mPathResolverCache;
    private final AtomicLong mNextOpenFileId = new AtomicLong(0L);
    private final FuseShell mFuseShell;
    private static final IndexDefinition<FuseFileEntry<FuseFileStream>, Long> ID_INDEX = IndexDefinition.ofUnique(FuseFileEntry::getId);
    private static final IndexDefinition<FuseFileEntry<FuseFileStream>, String> PATH_INDEX = IndexDefinition.ofUnique(FuseFileEntry::getPath);
    private final IndexedSet<FuseFileEntry<FuseFileStream>> mFileEntries = new IndexedSet(ID_INDEX, new IndexDefinition[]{PATH_INDEX});
    private final AuthPolicy mAuthPolicy;
    private final FuseFileStream.Factory mStreamFactory;
    private final boolean mUfsEnabled;
    @VisibleForTesting
    public static final int UNKNOWN_INODES = -1;

    public AlluxioJniFuseFileSystem(FileSystemContext fsContext, FileSystem fs, FuseOptions fuseOptions) {
        super(Paths.get(fsContext.getClusterConf().getString(PropertyKey.FUSE_MOUNT_POINT), new String[0]));
        this.mFileSystemContext = fsContext;
        this.mFileSystem = fs;
        this.mConf = fsContext.getClusterConf();
        this.mFuseShell = new FuseShell(fs, this.mConf);
        long statCacheTimeout = this.mConf.getMs(PropertyKey.FUSE_STAT_CACHE_REFRESH_INTERVAL);
        this.mFsStatCache = statCacheTimeout > 0L ? Suppliers.memoizeWithExpiration(this::acquireBlockMasterInfo, (long)statCacheTimeout, (TimeUnit)TimeUnit.MILLISECONDS) : this::acquireBlockMasterInfo;
        this.mPathResolverCache = AlluxioFuseUtils.getPathResolverCache(this.mConf, fuseOptions);
        this.mAuthPolicy = AuthPolicyFactory.create(this.mFileSystem, this.mConf, (FuseFileSystem)this);
        this.mStreamFactory = new FuseFileStream.Factory(this.mFileSystem, this.mAuthPolicy);
        this.mUfsEnabled = fuseOptions.getFileSystemOptions().getUfsFileSystemOptions().isPresent();
        if (this.mConf.getBoolean(PropertyKey.FUSE_DEBUG_ENABLED)) {
            try {
                LogUtils.setLogLevel((String)this.getClass().getName(), (String)Level.DEBUG.toString());
            }
            catch (IOException e) {
                LOG.error("Failed to set AlluxioJniFuseFileSystem log to debug level", (Throwable)e);
            }
        }
        MetricsSystem.registerGaugeIfAbsent((String)MetricsSystem.getMetricName((String)MetricKey.FUSE_READ_WRITE_FILE_COUNT.getName()), () -> this.mFileEntries.size());
        MetricsSystem.registerGaugeIfAbsent((String)MetricsSystem.getMetricName((String)MetricKey.FUSE_CACHED_PATH_COUNT.getName()), () -> this.mPathResolverCache.size());
    }

    public int create(String path, long mode, FuseFileInfo fi) {
        int originalFlags = fi.flags.get();
        fi.flags.set(OpenFlags.O_WRONLY.intValue() | fi.flags.get());
        return AlluxioFuseUtils.call(LOG, () -> this.createOrOpenInternal(path, fi, mode), "Fuse.Create", "path=%s,mode=%o,flags=0x%x", path, mode, originalFlags);
    }

    public int open(String path, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.createOrOpenInternal(path, fi, -1L), "Fuse.Open", "path=%s,flags=0x%x", path, fi.flags.get());
    }

    private int createOrOpenInternal(String path, FuseFileInfo fi, long mode) {
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        int res = AlluxioFuseUtils.checkNameLength(uri);
        if (res != 0) {
            return res;
        }
        try {
            FuseFileStream stream = this.mStreamFactory.create(uri, fi.flags.get(), mode);
            long fd = this.mNextOpenFileId.getAndIncrement();
            this.mFileEntries.add(new FuseFileEntry<FuseFileStream>(fd, path, stream));
            fi.fh.set(fd);
        }
        catch (NotFoundRuntimeException e) {
            LOG.error("Failed to read {}: path does not exist or is invalid", (Object)path, (Object)e);
            return -ErrorCodes.ENOENT();
        }
        catch (AlreadyExistsRuntimeException e) {
            LOG.error("Failed to write {}: path already exist", (Object)path, (Object)e);
            return -ErrorCodes.EEXIST();
        }
        catch (DeadlineExceededRuntimeException e) {
            LOG.error("Failed to create stream {}: deadline exceed", (Object)path, (Object)e);
            return -ErrorCodes.ETIME();
        }
        catch (CancelledRuntimeException e) {
            LOG.error("Failed to create stream {}: cancelled/interrupted", (Object)path, (Object)e);
            return -ErrorCodes.ECANCELED();
        }
        catch (UnimplementedRuntimeException e) {
            LOG.error("Failed to create stream {}: operation does not supported", (Object)path, (Object)e);
            return -ErrorCodes.ENOSYS();
        }
        return 0;
    }

    public int getattr(String path, FileStat stat) {
        return AlluxioFuseUtils.call(LOG, () -> this.getattrInternal(path, stat), "Fuse.Getattr", "path=%s", path);
    }

    private int getattrInternal(String path, FileStat stat) {
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        int res = AlluxioFuseUtils.checkNameLength(uri);
        if (res != 0) {
            return res;
        }
        try {
            if (this.mConf.getBoolean(PropertyKey.FUSE_SPECIAL_COMMAND_ENABLED) && this.mFuseShell.isSpecialCommand(uri)) {
                AlluxioFuseUtils.fillStat(this.mAuthPolicy, stat, this.mFuseShell.runCommand(uri));
                return 0;
            }
            Optional<URIStatus> status = AlluxioFuseUtils.getPathStatus(this.mFileSystem, uri);
            status.ifPresent(uriStatus -> AlluxioFuseUtils.fillStat(this.mAuthPolicy, stat, uriStatus));
            boolean hasWriteStream = false;
            Set fuseStreams = this.mFileEntries.getByField(PATH_INDEX, (Object)path);
            if (!fuseStreams.isEmpty()) {
                for (FuseFileEntry stream : fuseStreams) {
                    FileStatus fileStatus = stream.getFileStream().getFileStatus();
                    if (!(fileStatus instanceof CreateFileStatus)) continue;
                    if (status.isPresent()) {
                        AlluxioFuseUtils.updateStatSize(stat, fileStatus.getFileLength());
                    } else {
                        AlluxioFuseUtils.fillStat(stat, (CreateFileStatus)fileStatus);
                    }
                    hasWriteStream = true;
                }
            }
            if (!hasWriteStream && status.isPresent() && !status.get().isCompleted()) {
                Optional<URIStatus> completedFileStatus = AlluxioFuseUtils.waitForFileCompleted(this.mFileSystem, uri);
                completedFileStatus.ifPresent(uriStatus -> AlluxioFuseUtils.updateStatSize(stat, uriStatus.getLength()));
                if (!completedFileStatus.isPresent()) {
                    LOG.error("File {} is not completed, cannot get accurate file length", (Object)path);
                }
            }
            if (!status.isPresent() && !hasWriteStream) {
                LOG.debug("Failed to getattr {}: path does not exist or is invalid", (Object)path);
                return -ErrorCodes.ENOENT();
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to getattr {}", (Object)path, (Object)t);
            return -ErrorCodes.EIO();
        }
        return 0;
    }

    public int readdir(String path, long buff, long filter, long offset, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.readdirInternal(path, buff, filter, offset, fi), "Fuse.Readdir", "path=%s", path);
    }

    private int readdirInternal(String path, long buff, long filter, long offset, FuseFileInfo fi) {
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        int res = AlluxioFuseUtils.checkNameLength(uri);
        if (res != 0) {
            return res;
        }
        try {
            FuseFillDir.apply((long)filter, (long)buff, (String)".", null, (long)0L);
            FuseFillDir.apply((long)filter, (long)buff, (String)"..", null, (long)0L);
            this.mFileSystem.iterateStatus(uri, file -> FuseFillDir.apply((long)filter, (long)buff, (String)file.getName(), null, (long)0L));
        }
        catch (AlluxioException | IOException e) {
            LOG.error("Failed to readdir {}", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
        return 0;
    }

    public int read(String path, ByteBuffer buf, long size, long offset, FuseFileInfo fi) {
        long fd = fi.fh.get();
        return AlluxioFuseUtils.call(LOG, () -> this.readInternal(path, buf, size, offset, fd), "Fuse.Read", "path=%s,fd=%d,size=%d,offset=%d", path, fd, size, offset);
    }

    private int readInternal(String path, ByteBuffer buf, long size, long offset, long fd) {
        FuseFileEntry entry = (FuseFileEntry)this.mFileEntries.getFirstByField(ID_INDEX, (Object)fd);
        if (entry == null) {
            LOG.error("Failed to read {}: Cannot find fd {}", (Object)path, (Object)fd);
            return -ErrorCodes.EBADFD();
        }
        try {
            return entry.getFileStream().read(buf, size, offset);
        }
        catch (NotFoundRuntimeException e) {
            LOG.error("Failed to read {}: File does not exist or is writing by other clients", (Object)path);
            return -ErrorCodes.ENOENT();
        }
    }

    public int write(String path, ByteBuffer buf, long size, long offset, FuseFileInfo fi) {
        long fd = fi.fh.get();
        return AlluxioFuseUtils.call(LOG, () -> this.writeInternal(path, buf, size, offset, fd), "Fuse.Write", "path=%s,fd=%d,size=%d,offset=%d", path, fd, size, offset);
    }

    private int writeInternal(String path, ByteBuffer buf, long size, long offset, long fd) {
        FuseFileEntry entry = (FuseFileEntry)this.mFileEntries.getFirstByField(ID_INDEX, (Object)fd);
        if (entry == null) {
            LOG.error("Failed to write {}: Cannot find fd {}", (Object)path, (Object)fd);
            return -ErrorCodes.EBADFD();
        }
        try {
            entry.getFileStream().write(buf, size, offset);
        }
        catch (AlreadyExistsRuntimeException e) {
            LOG.error("Failed to write {}: cannot overwrite existing file", (Object)path);
            return -ErrorCodes.EEXIST();
        }
        catch (UnimplementedRuntimeException e) {
            LOG.error("Failed to write {}: not supported", (Object)path, (Object)e);
            return -ErrorCodes.EOPNOTSUPP();
        }
        return (int)size;
    }

    public int flush(String path, FuseFileInfo fi) {
        long fd = fi.fh.get();
        return AlluxioFuseUtils.call(LOG, () -> this.flushInternal(path, fd), "Fuse.Flush", "path=%s,fd=%s", path, fd);
    }

    private int flushInternal(String path, long fd) {
        FuseFileEntry entry = (FuseFileEntry)this.mFileEntries.getFirstByField(ID_INDEX, (Object)fd);
        if (entry == null) {
            LOG.error("Failed to flush {}: Cannot find fd {}", (Object)path, (Object)fd);
            return -ErrorCodes.EBADFD();
        }
        entry.getFileStream().flush();
        return 0;
    }

    public int release(String path, FuseFileInfo fi) {
        long fd = fi.fh.get();
        return AlluxioFuseUtils.call(LOG, () -> this.releaseInternal(path, fd), "Fuse.Release", "path=%s,fd=%s", path, fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int releaseInternal(String path, long fd) {
        FuseFileEntry entry = (FuseFileEntry)this.mFileEntries.getFirstByField(ID_INDEX, (Object)fd);
        if (entry == null) {
            LOG.error("Failed to release {}: Cannot find fd {}", (Object)path, (Object)fd);
            return -ErrorCodes.EBADFD();
        }
        try {
            entry.getFileStream().close();
        }
        finally {
            this.mFileEntries.remove((Object)entry);
        }
        return 0;
    }

    public int mkdir(String path, long mode) {
        return AlluxioFuseUtils.call(LOG, () -> this.mkdirInternal(path, mode), "Fuse.Mkdir", "path=%s,mode=%o,", path, mode);
    }

    private int mkdirInternal(String path, long mode) {
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        int res = AlluxioFuseUtils.checkNameLength(uri);
        if (res != 0) {
            return res;
        }
        try {
            this.mFileSystem.createDirectory(uri, CreateDirectoryPOptions.newBuilder().setMode(new Mode((short)mode).toProto()).build());
            this.mAuthPolicy.setUserGroupIfNeeded(uri);
        }
        catch (AlluxioException | IOException e) {
            LOG.error("Failed to mkdir {}", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
        return 0;
    }

    public int unlink(String path) {
        return AlluxioFuseUtils.call(LOG, () -> this.rmInternal(path), "Fuse.Unlink", "path=%s", path);
    }

    public int rmdir(String path) {
        return AlluxioFuseUtils.call(LOG, () -> this.rmInternal(path), "Fuse.Rmdir", "path=%s", path);
    }

    private int rmInternal(String path) {
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        int res = AlluxioFuseUtils.checkNameLength(uri);
        if (res != 0) {
            return res;
        }
        try {
            this.mFileSystem.delete(uri);
        }
        catch (DirectoryNotEmptyException de) {
            LOG.error("Failed to remove {}: directory not empty", (Object)path, (Object)de);
            return -ErrorCodes.EEXIST() | ErrorCodes.ENOTEMPTY();
        }
        catch (FileDoesNotExistException fe) {
            LOG.error("Failed to remove {}: path does not exist", (Object)path, (Object)fe);
            return -ErrorCodes.ENOENT();
        }
        catch (AlluxioException | IOException e) {
            LOG.error("Failed to remove {}: ", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
        return 0;
    }

    public int rename(String oldPath, String newPath, int flags) {
        return AlluxioFuseUtils.call(LOG, () -> this.renameInternal(oldPath, newPath, flags), "Fuse.Rename", "oldPath=%s,newPath=%s,", oldPath, newPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int renameInternal(String sourcePath, String destPath, int flags) {
        AlluxioURI sourceUri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)sourcePath);
        AlluxioURI destUri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)destPath);
        int res = AlluxioFuseUtils.checkNameLength(destUri);
        if (res != 0) {
            return res;
        }
        Optional<URIStatus> sourceStatus = AlluxioFuseUtils.getPathStatus(this.mFileSystem, sourceUri);
        if (!sourceStatus.isPresent()) {
            LOG.error("Failed to rename {} to {}: source non-existing", (Object)sourcePath, (Object)destPath);
            return -ErrorCodes.ENOENT();
        }
        if (!sourceStatus.get().isCompleted()) {
            LOG.error("Failed to rename {} to {}: source is incomplete", (Object)sourcePath, (Object)destPath);
            return -ErrorCodes.EIO();
        }
        Optional<URIStatus> destStatus = AlluxioFuseUtils.getPathStatus(this.mFileSystem, destUri);
        try {
            if (destStatus.isPresent()) {
                if (AlluxioJniRenameUtils.exchange(flags)) {
                    LOG.error("Failed to rename {} to {}, not support RENAME_EXCHANGE flags", (Object)sourcePath, (Object)destPath);
                    return -ErrorCodes.ENOTSUP();
                }
                if (AlluxioJniRenameUtils.noreplace(flags)) {
                    LOG.error("Failed to rename {} to {}, overwriting destination with RENAME_NOREPLACE flag", (Object)sourcePath, (Object)destPath);
                    return -ErrorCodes.EEXIST();
                }
                if (!AlluxioJniRenameUtils.noFlags(flags)) {
                    LOG.error("Failed to rename {} to {}, unknown flags {}", new Object[]{sourcePath, destPath, flags});
                    return -ErrorCodes.EINVAL();
                }
                try {
                    this.mFileSystem.delete(destUri);
                }
                catch (DirectoryNotEmptyException e) {
                    return -ErrorCodes.ENOTEMPTY();
                }
            } else if (AlluxioJniRenameUtils.exchange(flags)) {
                LOG.error("Failed to rename {} to {}, destination file/dir must exist to RENAME_EXCHANGE", (Object)sourcePath, (Object)destPath);
            }
            this.mFileSystem.rename(sourceUri, destUri);
            return 0;
        }
        catch (AlluxioException | IOException e) {
            LOG.error("Failed to rename {} to {}", new Object[]{sourcePath, destPath, e});
            return -ErrorCodes.EIO();
        }
    }

    public int chmod(String path, long mode) {
        return AlluxioFuseUtils.call(LOG, () -> this.chmodInternal(path, mode), "Fuse.Chmod", "path=%s,mode=%o", path, mode);
    }

    private int chmodInternal(String path, long mode) {
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        int res = AlluxioFuseUtils.checkNameLength(uri);
        if (res != 0) {
            return res;
        }
        AlluxioFuseUtils.setAttribute(this.mFileSystem, (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path), SetAttributePOptions.newBuilder().setMode(new Mode((short)mode).toProto()).build());
        return 0;
    }

    public int chown(String path, long uid, long gid) {
        return AlluxioFuseUtils.call(LOG, () -> this.chownInternal(path, uid, gid), "Fuse.Chown", "path=%s,uid=%d,gid=%d", path, uid, gid);
    }

    private int chownInternal(String path, long uid, long gid) {
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        int res = AlluxioFuseUtils.checkNameLength(uri);
        if (res != 0) {
            return res;
        }
        this.mAuthPolicy.setUserGroup(uri, uid, gid);
        return 0;
    }

    public int truncate(String path, long size) {
        return AlluxioFuseUtils.call(LOG, () -> this.truncateInternal(path, size), "Fuse.Truncate", "path=%s,size=%d", path, size);
    }

    private int truncateInternal(String path, long size) {
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        int res = AlluxioFuseUtils.checkNameLength(uri);
        if (res != 0) {
            return res;
        }
        try {
            FuseFileEntry entry = (FuseFileEntry)this.mFileEntries.getFirstByField(PATH_INDEX, (Object)path);
            if (entry != null) {
                entry.getFileStream().truncate(size);
                return 0;
            }
            Optional<URIStatus> status = AlluxioFuseUtils.getPathStatus(this.mFileSystem, uri);
            if (!status.isPresent()) {
                if (size == 0L) {
                    return 0;
                }
                LOG.error("Failed to truncate file {} to {} bytes: file does not exist", (Object)path, (Object)size);
                return -ErrorCodes.EEXIST();
            }
            if (status.get().isCompleted()) {
                long fileLen = status.get().getLength();
                if (fileLen == size) {
                    return 0;
                }
                if (size == 0L) {
                    AlluxioFuseUtils.deletePath(this.mFileSystem, uri);
                }
                LOG.error("Failed to truncate file {}({} bytes) to {} bytes: not supported.", new Object[]{path, fileLen, size});
                return -ErrorCodes.EOPNOTSUPP();
            }
            LOG.error("Failed to truncate file {} to {} bytes: file is being written by other Fuse applications or Alluxio APIs.", (Object)path, (Object)size);
            return -ErrorCodes.EOPNOTSUPP();
        }
        catch (UnimplementedRuntimeException e) {
            LOG.error("Failed to truncate file {} to {} bytes: not supported", (Object)path, (Object)size);
            return -ErrorCodes.EOPNOTSUPP();
        }
    }

    public int utimens(String path, long aSec, long aNsec, long mSec, long mNsec) {
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        int res = AlluxioFuseUtils.checkNameLength(uri);
        if (res != 0) {
            return res;
        }
        LOG.debug("utimens for {}, but do nothing for this filesystem", (Object)path);
        return 0;
    }

    public int symlink(String linkname, String path) {
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        int res = AlluxioFuseUtils.checkNameLength(uri);
        if (res != 0) {
            return res;
        }
        LOG.warn("Not supported symlink operation, linkname {}, path{}", (Object)linkname, (Object)path);
        return -ErrorCodes.ENOTSUP();
    }

    public int statfs(String path, Statvfs stbuf) {
        return AlluxioFuseUtils.call(LOG, () -> this.statfsInternal(path, stbuf), "Fuse.Statfs", "path=%s", path);
    }

    private int statfsInternal(String path, Statvfs stbuf) {
        if (this.mUfsEnabled) {
            return 0;
        }
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        int res = AlluxioFuseUtils.checkNameLength(uri);
        if (res != 0) {
            return res;
        }
        BlockMasterInfo info = this.mFsStatCache.get();
        if (info == null) {
            LOG.error("Failed to statfs {}: cannot get block master info", (Object)path);
            return -ErrorCodes.EIO();
        }
        long blockSize = 16384L;
        stbuf.f_bsize.set((Number)blockSize);
        stbuf.f_frsize.set((Number)blockSize);
        stbuf.f_blocks.set((Number)(info.getCapacityBytes() / blockSize));
        long freeBlocks = info.getFreeBytes() / blockSize;
        stbuf.f_bfree.set((Number)freeBlocks);
        stbuf.f_bavail.set((Number)freeBlocks);
        stbuf.f_files.set((Number)-1);
        stbuf.f_ffree.set((Number)-1);
        stbuf.f_favail.set((Number)-1);
        stbuf.f_namemax.set((Number)255);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private BlockMasterInfo acquireBlockMasterInfo() {
        try (CloseableResource masterClientResource = this.mFileSystemContext.acquireBlockMasterClientResource();){
            HashSet<BlockMasterInfo.BlockMasterInfoField> blockMasterInfoFilter = new HashSet<BlockMasterInfo.BlockMasterInfoField>(Arrays.asList(BlockMasterInfo.BlockMasterInfoField.CAPACITY_BYTES, BlockMasterInfo.BlockMasterInfoField.FREE_BYTES, BlockMasterInfo.BlockMasterInfoField.USED_BYTES));
            BlockMasterInfo blockMasterInfo = ((BlockMasterClient)masterClientResource.get()).getBlockMasterInfo(blockMasterInfoFilter);
            return blockMasterInfo;
        }
        catch (IOException e) {
            LOG.error("Failed to acquire block master information", (Throwable)e);
            return null;
        }
    }

    public String getFileSystemName() {
        return this.mConf.getString(PropertyKey.FUSE_FS_NAME);
    }

    @Override
    public void umount(boolean force) {
        block4: {
            long unmountTimeout = this.mConf.getMs(PropertyKey.FUSE_UMOUNT_TIMEOUT);
            String mountpoint = this.mConf.getString(PropertyKey.FUSE_MOUNT_POINT);
            if (unmountTimeout > 0L && !this.mFileEntries.isEmpty()) {
                LOG.info("Unmounting {}. Waiting for all in progress file read/write to finish", (Object)mountpoint);
                try {
                    CommonUtils.waitFor((String)"all in progress file read/write to finish", () -> this.mFileEntries.isEmpty(), (WaitForOptions)WaitForOptions.defaults().setTimeoutMs((long)((int)unmountTimeout)));
                }
                catch (InterruptedException e) {
                    LOG.error("Unmount {} interrupted", (Object)mountpoint);
                    Thread.currentThread().interrupt();
                    throw new CancelledRuntimeException("Unmount interrupted", (Throwable)e);
                }
                catch (TimeoutException e) {
                    LOG.error("Timeout when waiting all in progress file read/write to finish when unmounting {}. {} file streams remain unclosed.", (Object)mountpoint, (Object)this.mFileEntries.size());
                    if (force) break block4;
                    throw new AlluxioRuntimeException(Status.DEADLINE_EXCEEDED, "Timed out for umount due to device is busy.", (Throwable)e, ErrorType.External, false, new Any[0]);
                }
            }
        }
        super.umount(force);
    }

    @VisibleForTesting
    LoadingCache<String, AlluxioURI> getPathResolverCache() {
        return this.mPathResolverCache;
    }
}

