/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.collections.IndexDefinition;
import alluxio.collections.IndexedSet;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.FileIncompleteException;
import alluxio.exception.OpenDirectoryException;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.FuseUmountable;
import alluxio.fuse.OpenFileEntry;
import alluxio.fuse.options.FuseOptions;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.master.MasterClientContext;
import alluxio.security.authorization.Mode;
import alluxio.wire.BlockMasterInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import jnr.ffi.Pointer;
import jnr.ffi.types.gid_t;
import jnr.ffi.types.mode_t;
import jnr.ffi.types.off_t;
import jnr.ffi.types.size_t;
import jnr.ffi.types.uid_t;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.FuseFillDir;
import ru.serce.jnrfuse.FuseStubFS;
import ru.serce.jnrfuse.struct.FileStat;
import ru.serce.jnrfuse.struct.FuseContext;
import ru.serce.jnrfuse.struct.FuseFileInfo;
import ru.serce.jnrfuse.struct.Statvfs;
import ru.serce.jnrfuse.struct.Timespec;

@ThreadSafe
public final class AlluxioJnrFuseFileSystem
extends FuseStubFS
implements FuseUmountable {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioJnrFuseFileSystem.class);
    private static final int MAX_OPEN_FILES = Integer.MAX_VALUE;
    @VisibleForTesting
    public static final int UNKNOWN_INODES = -1;
    @VisibleForTesting
    public static final int MAX_NAME_LENGTH = 255;
    @VisibleForTesting
    public static final long ID_NOT_SET_VALUE = -1L;
    @VisibleForTesting
    public static final long ID_NOT_SET_VALUE_UNSIGNED = 0xFFFFFFFFL;
    private static final long UID = AlluxioFuseUtils.getUid(System.getProperty("user.name")).orElse(-1L);
    private static final long GID = AlluxioFuseUtils.getGidFromUserName(System.getProperty("user.name")).orElse(-1L);
    private static final IndexDefinition<OpenFileEntry<FileInStream, FileOutStream>, Long> ID_INDEX = IndexDefinition.ofUnique(OpenFileEntry::getId);
    private static final IndexDefinition<OpenFileEntry<FileInStream, FileOutStream>, String> PATH_INDEX = IndexDefinition.ofUnique(OpenFileEntry::getPath);
    private final boolean mIsUserGroupTranslation;
    private final FileSystem mFileSystem;
    private final LoadingCache<String, AlluxioURI> mPathResolverCache;
    private final IndexedSet<OpenFileEntry<FileInStream, FileOutStream>> mOpenFiles;
    private AtomicLong mNextOpenFileId = new AtomicLong(0L);
    private final String mFsName;

    public AlluxioJnrFuseFileSystem(FileSystem fs, AlluxioConfiguration conf, FuseOptions fuseOptions) {
        this.mFsName = conf.getString(PropertyKey.FUSE_FS_NAME);
        this.mFileSystem = fs;
        this.mOpenFiles = new IndexedSet(ID_INDEX, new IndexDefinition[]{PATH_INDEX});
        this.mIsUserGroupTranslation = conf.getBoolean(PropertyKey.FUSE_USER_GROUP_TRANSLATION_ENABLED);
        this.mPathResolverCache = AlluxioFuseUtils.getPathResolverCache(conf, fuseOptions);
    }

    public int chmod(String path, @mode_t long mode) {
        return AlluxioFuseUtils.call(LOG, () -> this.chmodInternal(path, mode), "chmod", "path=%s,mode=%o", path, mode);
    }

    private int chmodInternal(String path, @mode_t long mode) {
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        SetAttributePOptions options = SetAttributePOptions.newBuilder().setMode(new Mode((short)mode).toProto()).build();
        try {
            this.mFileSystem.setAttribute(uri, options);
        }
        catch (Throwable t) {
            LOG.error("Failed to change {} to mode {}", new Object[]{path, mode, t});
            return AlluxioFuseUtils.getErrorCode(t);
        }
        return 0;
    }

    public int chown(String path, @uid_t long uid, @gid_t long gid) {
        return AlluxioFuseUtils.call(LOG, () -> this.chownInternal(path, uid, gid), "chown", "path=%s,uid=%d,gid=%d", path, uid, gid);
    }

    private int chownInternal(String path, @uid_t long uid, @gid_t long gid) {
        if (!this.mIsUserGroupTranslation) {
            LOG.info("Cannot change the owner/group of path {}. Please set {} to be true to enable user group translation in Alluxio-FUSE.", (Object)path, (Object)PropertyKey.FUSE_USER_GROUP_TRANSLATION_ENABLED.getName());
            return -ErrorCodes.EOPNOTSUPP();
        }
        try {
            SetAttributePOptions.Builder optionsBuilder = SetAttributePOptions.newBuilder();
            AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
            AlluxioFuseUtils.getUserName(uid).ifPresent(arg_0 -> ((SetAttributePOptions.Builder)optionsBuilder).setOwner(arg_0));
            AlluxioFuseUtils.getGroupName(gid).ifPresent(arg_0 -> ((SetAttributePOptions.Builder)optionsBuilder).setGroup(arg_0));
            SetAttributePOptions options = optionsBuilder.build();
            LOG.info("Changing attribute of file {} to {}", (Object)path, (Object)options);
            this.mFileSystem.setAttribute(uri, options);
        }
        catch (Throwable t) {
            LOG.error("Failed to chown {} to uid {} and gid {}", new Object[]{path, uid, gid, t});
            return AlluxioFuseUtils.getErrorCode(t);
        }
        return 0;
    }

    public int create(String path, @mode_t long mode, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.createInternal(path, mode, fi), "create", "path=%s,mode=%o", path, mode);
    }

    private int createInternal(String path, @mode_t long mode, FuseFileInfo fi) {
        AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        if (uri.getName().length() > 255) {
            LOG.error("Failed to create {}, file name is longer than {} characters", (Object)path, (Object)255);
            return -ErrorCodes.ENAMETOOLONG();
        }
        try {
            if (this.mOpenFiles.size() >= Integer.MAX_VALUE) {
                LOG.error("Cannot create {}: too many open files (MAX_OPEN_FILES: {})", (Object)path, (Object)Integer.MAX_VALUE);
                return -ErrorCodes.EMFILE();
            }
            FileOutStream os = this.mFileSystem.createFile(uri, CreateFilePOptions.newBuilder().setMode(new Mode((short)mode).toProto()).build());
            long fid = this.mNextOpenFileId.getAndIncrement();
            this.mOpenFiles.add(new OpenFileEntry<Object, FileOutStream>(fid, path, null, os));
            fi.fh.set(fid);
            FuseContext fc = this.getContext();
            long uid = fc.uid.get();
            long gid = fc.gid.get();
            if (gid != GID || uid != UID) {
                SetAttributePOptions.Builder optionsBuilder = SetAttributePOptions.newBuilder();
                AlluxioFuseUtils.getUserName(uid).ifPresent(arg_0 -> ((SetAttributePOptions.Builder)optionsBuilder).setOwner(arg_0));
                AlluxioFuseUtils.getGroupName(gid).ifPresent(arg_0 -> ((SetAttributePOptions.Builder)optionsBuilder).setGroup(arg_0));
                SetAttributePOptions options = optionsBuilder.build();
                LOG.debug("Changing attribute of file {} to {}", (Object)path, (Object)options);
                this.mFileSystem.setAttribute(uri, options);
            }
        }
        catch (FileAlreadyExistsException e) {
            LOG.debug("Failed to create {}, file already exists", (Object)path);
            return -ErrorCodes.EEXIST();
        }
        catch (InvalidPathException e) {
            LOG.debug("Failed to create {}, path is invalid", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (Throwable t) {
            LOG.error("Failed to create {}", (Object)path, (Object)t);
            return AlluxioFuseUtils.getErrorCode(t);
        }
        return 0;
    }

    public int flush(String path, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.flushInternal(path, fi), "flush", "path=%s", path);
    }

    private int flushInternal(String path, FuseFileInfo fi) {
        long fd = fi.fh.get();
        OpenFileEntry oe = (OpenFileEntry)this.mOpenFiles.getFirstByField(ID_INDEX, (Object)fd);
        if (oe == null) {
            LOG.error("Cannot find fd for {} in table", (Object)path);
            return -ErrorCodes.EBADFD();
        }
        if (oe.getOut() != null) {
            try {
                ((OutputStream)oe.getOut()).flush();
            }
            catch (IOException e) {
                LOG.error("Failed to flush {}", (Object)path, (Object)e);
                return -ErrorCodes.EIO();
            }
        } else {
            LOG.debug("Not flushing: {} was not open for writing", (Object)path);
        }
        return 0;
    }

    public int getattr(String path, FileStat stat) {
        return AlluxioFuseUtils.call(LOG, () -> this.getattrInternal(path, stat), "getattr", "path=%s", path);
    }

    private int getattrInternal(String path, FileStat stat) {
        AlluxioURI turi = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        try {
            URIStatus status = this.mFileSystem.getStatus(turi);
            if (!status.isCompleted() && !this.mOpenFiles.contains(PATH_INDEX, (Object)path)) {
                Optional<URIStatus> optionalStatus = AlluxioFuseUtils.waitForFileCompleted(this.mFileSystem, turi);
                if (optionalStatus.isPresent()) {
                    status = optionalStatus.get();
                } else {
                    LOG.error("File {} is not completed", (Object)path);
                }
            }
            long size = status.getLength();
            stat.st_size.set((Number)size);
            stat.st_blocks.set((Number)((int)Math.ceil((double)size / 512.0)));
            long ctime_sec = status.getLastModificationTimeMs() / 1000L;
            long ctime_nsec = status.getLastModificationTimeMs() % 1000L * 1000L;
            stat.st_ctim.tv_sec.set(ctime_sec);
            stat.st_ctim.tv_nsec.set((Number)ctime_nsec);
            stat.st_mtim.tv_sec.set(ctime_sec);
            stat.st_mtim.tv_nsec.set((Number)ctime_nsec);
            if (this.mIsUserGroupTranslation) {
                stat.st_uid.set((Number)AlluxioFuseUtils.getUid(status.getOwner()).orElse(-1L));
                stat.st_gid.set((Number)AlluxioFuseUtils.getGidFromGroupName(status.getGroup()).orElse(-1L));
            } else {
                stat.st_uid.set(UID);
                stat.st_gid.set(GID);
            }
            int mode = status.getMode();
            mode = status.isFolder() ? (mode |= 0x4000) : (mode |= 0x8000);
            stat.st_mode.set((Number)mode);
            stat.st_nlink.set((Number)1);
        }
        catch (FileDoesNotExistException | InvalidPathException e) {
            LOG.debug("Failed to get info of {}, path does not exist or is invalid", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (Throwable t) {
            LOG.error("Failed to get info of {}", (Object)path, (Object)t);
            return AlluxioFuseUtils.getErrorCode(t);
        }
        return 0;
    }

    public String getFSName() {
        return this.mFsName;
    }

    public int mkdir(String path, @mode_t long mode) {
        return AlluxioFuseUtils.call(LOG, () -> this.mkdirInternal(path, mode), "mkdir", "path=%s,mode=%o,", path, mode);
    }

    private int mkdirInternal(String path, @mode_t long mode) {
        AlluxioURI turi = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        if (turi.getName().length() > 255) {
            LOG.error("Failed to create directory {}, directory name is longer than {} characters", (Object)path, (Object)255);
            return -ErrorCodes.ENAMETOOLONG();
        }
        try {
            this.mFileSystem.createDirectory(turi, CreateDirectoryPOptions.newBuilder().setMode(new Mode((short)mode).toProto()).build());
            FuseContext fc = this.getContext();
            long uid = fc.uid.get();
            long gid = fc.gid.get();
            if (gid != GID || uid != UID) {
                SetAttributePOptions.Builder optionsBuilder = SetAttributePOptions.newBuilder();
                AlluxioFuseUtils.getUserName(uid).ifPresent(arg_0 -> ((SetAttributePOptions.Builder)optionsBuilder).setOwner(arg_0));
                AlluxioFuseUtils.getGroupName(gid).ifPresent(arg_0 -> ((SetAttributePOptions.Builder)optionsBuilder).setGroup(arg_0));
                SetAttributePOptions options = optionsBuilder.build();
                LOG.debug("Changing attribute of file {} to {}", (Object)path, (Object)options);
                this.mFileSystem.setAttribute(turi, options);
            }
        }
        catch (FileAlreadyExistsException e) {
            LOG.debug("Failed to create directory {}, directory already exists", (Object)path);
            return -ErrorCodes.EEXIST();
        }
        catch (InvalidPathException e) {
            LOG.debug("Failed to create directory {}, path is invalid", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (Throwable t) {
            LOG.error("Failed to create directory {}", (Object)path, (Object)t);
            return AlluxioFuseUtils.getErrorCode(t);
        }
        return 0;
    }

    public int open(String path, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.openInternal(path, fi), "open", "path=%s", path);
    }

    private int openInternal(String path, FuseFileInfo fi) {
        FileInStream is;
        block9: {
            AlluxioURI uri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
            int flags = fi.flags.get();
            if (this.mOpenFiles.size() >= Integer.MAX_VALUE) {
                LOG.error("Cannot open {}: too many open files (MAX_OPEN_FILES: {})", (Object)path, (Object)Integer.MAX_VALUE);
                return ErrorCodes.EMFILE();
            }
            try {
                try {
                    is = this.mFileSystem.openFile(uri);
                }
                catch (FileIncompleteException e) {
                    if (AlluxioFuseUtils.waitForFileCompleted(this.mFileSystem, uri).isPresent()) {
                        is = this.mFileSystem.openFile(uri);
                        break block9;
                    }
                    throw e;
                }
            }
            catch (OpenDirectoryException e) {
                LOG.error("Cannot open folder {}", (Object)path);
                return -ErrorCodes.EISDIR();
            }
            catch (FileIncompleteException e) {
                LOG.error("Cannot open incomplete file {}", (Object)path);
                return -ErrorCodes.EFAULT();
            }
            catch (FileDoesNotExistException | InvalidPathException e) {
                LOG.error("Failed to open file {}, path does not exist or is invalid", (Object)path);
                return -ErrorCodes.ENOENT();
            }
            catch (Throwable t) {
                LOG.error("Failed to open file {}", (Object)path, (Object)t);
                return AlluxioFuseUtils.getErrorCode(t);
            }
        }
        long fid = this.mNextOpenFileId.getAndIncrement();
        this.mOpenFiles.add(new OpenFileEntry<FileInStream, Object>(fid, path, is, null));
        fi.fh.set(fid);
        return 0;
    }

    public int read(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.readInternal(path, buf, size, offset, fi), "read", "path=%s,buf=%s,size=%d,offset=%d", path, buf, size, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readInternal(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        if (size > Integer.MAX_VALUE) {
            LOG.error("Cannot read more than Integer.MAX_VALUE");
            return -ErrorCodes.EINVAL();
        }
        long fd = fi.fh.get();
        OpenFileEntry oe = (OpenFileEntry)this.mOpenFiles.getFirstByField(ID_INDEX, (Object)fd);
        if (oe == null) {
            LOG.error("Cannot find fd for {} in table", (Object)path);
            return -ErrorCodes.EBADFD();
        }
        if (oe.getIn() == null) {
            LOG.error("{} was not open for reading", (Object)path);
            return -ErrorCodes.EBADFD();
        }
        int rd = 0;
        int nread = 0;
        OpenFileEntry openFileEntry = oe;
        synchronized (openFileEntry) {
            if (!this.mOpenFiles.contains((Object)oe)) {
                LOG.error("Cannot find fd for {} in table", (Object)path);
                return -ErrorCodes.EBADFD();
            }
            FileInStream is = (FileInStream)oe.getIn();
            try {
                if (offset - is.getPos() < is.remaining()) {
                    is.seek(offset);
                    int sz = (int)size;
                    byte[] dest = new byte[sz];
                    while (rd >= 0 && nread < sz) {
                        rd = ((FileInStream)oe.getIn()).read(dest, nread, sz - nread);
                        if (rd < 0) continue;
                        nread += rd;
                    }
                    if (nread == -1) {
                        nread = 0;
                    } else if (nread > 0) {
                        buf.put(0L, dest, 0, nread);
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("Failed to read file={}, offset={}, size={}", new Object[]{path, offset, size, t});
                return AlluxioFuseUtils.getErrorCode(t);
            }
        }
        return nread;
    }

    public int readdir(String path, Pointer buff, FuseFillDir filter, @off_t long offset, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.readdirInternal(path, buff, filter, offset, fi), "readdir", "path=%s,buf=%s", path, buff);
    }

    private int readdirInternal(String path, Pointer buff, FuseFillDir filter, @off_t long offset, FuseFileInfo fi) {
        AlluxioURI turi = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        try {
            List ls = this.mFileSystem.listStatus(turi);
            filter.apply(buff, ".", null, 0L);
            filter.apply(buff, "..", null, 0L);
            for (URIStatus file : ls) {
                filter.apply(buff, file.getName(), null, 0L);
            }
        }
        catch (FileDoesNotExistException | InvalidPathException e) {
            LOG.debug("Failed to read directory {}, path does not exist or is invalid", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (Throwable t) {
            LOG.error("Failed to read directory {}", (Object)path, (Object)t);
            return AlluxioFuseUtils.getErrorCode(t);
        }
        return 0;
    }

    public int release(String path, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.releaseInternal(path, fi), "release", "path=%s", path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int releaseInternal(String path, FuseFileInfo fi) {
        long fd = fi.fh.get();
        OpenFileEntry oe = (OpenFileEntry)this.mOpenFiles.getFirstByField(ID_INDEX, (Object)fd);
        if (oe == null || !this.mOpenFiles.remove((Object)oe)) {
            LOG.error("Cannot find fd for {} in table", (Object)path);
            return -ErrorCodes.EBADFD();
        }
        try {
            OpenFileEntry openFileEntry = oe;
            synchronized (openFileEntry) {
                oe.close();
            }
        }
        catch (IOException e) {
            LOG.error("Failed closing {} [in]", (Object)path, (Object)e);
        }
        return 0;
    }

    public int rename(String oldPath, String newPath) {
        return AlluxioFuseUtils.call(LOG, () -> this.renameInternal(oldPath, newPath), "rename", "oldPath=%s,newPath=%s,", oldPath, newPath);
    }

    private int renameInternal(String oldPath, String newPath) {
        AlluxioURI oldUri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)oldPath);
        AlluxioURI newUri = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)newPath);
        String name = newUri.getName();
        if (name.length() > 255) {
            LOG.error("Failed to rename {} to {}, name {} is longer than {} characters", new Object[]{oldPath, newPath, name, 255});
            return -ErrorCodes.ENAMETOOLONG();
        }
        try {
            this.mFileSystem.rename(oldUri, newUri);
            OpenFileEntry oe = (OpenFileEntry)this.mOpenFiles.getFirstByField(PATH_INDEX, (Object)oldPath);
            if (oe != null) {
                oe.setPath(newPath);
            }
        }
        catch (FileDoesNotExistException e) {
            LOG.debug("Failed to rename {} to {}, file {} does not exist", new Object[]{oldPath, newPath, oldPath});
            return -ErrorCodes.ENOENT();
        }
        catch (FileAlreadyExistsException e) {
            LOG.debug("Failed to rename {} to {}, file {} already exists", new Object[]{oldPath, newPath, newPath});
            return -ErrorCodes.EEXIST();
        }
        catch (Throwable t) {
            LOG.error("Failed to rename {} to {}", new Object[]{oldPath, newPath, t});
            return AlluxioFuseUtils.getErrorCode(t);
        }
        return 0;
    }

    public int rmdir(String path) {
        return AlluxioFuseUtils.call(LOG, () -> this.rmInternal(path), "rmdir", "path=%s", path);
    }

    public int statfs(String path, Statvfs stbuf) {
        return AlluxioFuseUtils.call(LOG, () -> this.statfsInternal(path, stbuf), "statfs", "path=%s", path);
    }

    private int statfsInternal(String path, Statvfs stbuf) {
        ClientContext ctx = ClientContext.create();
        try (BlockMasterClient blockClient = BlockMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ctx).build());){
            HashSet<BlockMasterInfo.BlockMasterInfoField> blockMasterInfoFilter = new HashSet<BlockMasterInfo.BlockMasterInfoField>(Arrays.asList(BlockMasterInfo.BlockMasterInfoField.CAPACITY_BYTES, BlockMasterInfo.BlockMasterInfoField.FREE_BYTES, BlockMasterInfo.BlockMasterInfoField.USED_BYTES));
            BlockMasterInfo blockMasterInfo = blockClient.getBlockMasterInfo(blockMasterInfoFilter);
            long blockSize = 4096L;
            stbuf.f_bsize.set((Number)blockSize);
            stbuf.f_frsize.set((Number)blockSize);
            stbuf.f_blocks.set((Number)(blockMasterInfo.getCapacityBytes() / blockSize));
            long freeBlocks = blockMasterInfo.getFreeBytes() / blockSize;
            stbuf.f_bfree.set((Number)freeBlocks);
            stbuf.f_bavail.set((Number)freeBlocks);
            stbuf.f_files.set((Number)-1);
            stbuf.f_ffree.set((Number)-1);
            stbuf.f_favail.set((Number)-1);
            stbuf.f_namemax.set((Number)255);
        }
        catch (IOException e) {
            LOG.error("statfs({}) failed:", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
        return 0;
    }

    public int truncate(String path, long size) {
        LOG.error("Truncate is not supported {}", (Object)path);
        return -ErrorCodes.EOPNOTSUPP();
    }

    public int unlink(String path) {
        return AlluxioFuseUtils.call(LOG, () -> this.rmInternal(path), "unlink", "path=%s", path);
    }

    public int utimens(String path, Timespec[] timespec) {
        return 0;
    }

    public int write(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.writeInternal(path, buf, size, offset, fi), "write", "path=%s,buf=%s,size=%d,offset=%d", path, buf, size, offset);
    }

    private int writeInternal(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        if (size > Integer.MAX_VALUE) {
            LOG.error("Cannot write more than Integer.MAX_VALUE");
            return ErrorCodes.EIO();
        }
        int sz = (int)size;
        long fd = fi.fh.get();
        OpenFileEntry oe = (OpenFileEntry)this.mOpenFiles.getFirstByField(ID_INDEX, (Object)fd);
        if (oe == null) {
            LOG.error("Cannot find fd for {} in table", (Object)path);
            return -ErrorCodes.EBADFD();
        }
        if (oe.getOut() == null) {
            LOG.error("{} already exists in Alluxio and cannot be overwritten. Please delete this file first.", (Object)path);
            return -ErrorCodes.EEXIST();
        }
        if (offset < oe.getWriteOffset()) {
            return sz;
        }
        try {
            byte[] dest = new byte[sz];
            buf.get(0L, dest, 0, sz);
            ((OutputStream)oe.getOut()).write(dest);
            oe.setWriteOffset(offset + size);
        }
        catch (IOException e) {
            LOG.error("IOException while writing to {}.", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
        return sz;
    }

    private int rmInternal(String path) {
        AlluxioURI turi = (AlluxioURI)this.mPathResolverCache.getUnchecked((Object)path);
        try {
            this.mFileSystem.delete(turi);
        }
        catch (FileDoesNotExistException | InvalidPathException e) {
            LOG.debug("Failed to remove {}, file does not exist or is invalid", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (Throwable t) {
            LOG.error("Failed to remove {}", (Object)path, (Object)t);
            return AlluxioFuseUtils.getErrorCode(t);
        }
        return 0;
    }

    LoadingCache<String, AlluxioURI> getPathResolverCache() {
        return this.mPathResolverCache;
    }

    public void mount(Path mountPoint, boolean blocking, boolean debug, String[] fuseOpts) {
        LOG.info("Mount AlluxioFuseFileSystem: mountPoint=\"{}\", blocking={}, debug={}, fuseOpts=\"{}\"", new Object[]{mountPoint, blocking, debug, Arrays.toString(fuseOpts)});
        super.mount(mountPoint, blocking, debug, fuseOpts);
    }

    @Override
    public void umount(boolean force) {
        LOG.info("Umount AlluxioFuseFileSystem");
        super.umount();
    }
}

