/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse;

import alluxio.fuse.FuseUmountable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class FuseSignalHandler
implements SignalHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FuseSignalHandler.class);
    private FuseUmountable mFuseUmountable;

    public FuseSignalHandler(FuseUmountable fuseUmountable) {
        this.mFuseUmountable = fuseUmountable;
    }

    @Override
    public void handle(Signal signal) {
        LOG.info("Receive signal name {}, number {}, system exiting", (Object)signal.getName(), (Object)signal.getNumber());
        int number = signal.getNumber();
        if (number == 15) {
            try {
                this.mFuseUmountable.umount(false);
            }
            catch (Throwable t) {
                LOG.error("unable to umount fuse.", t);
                return;
            }
        }
        System.exit(0);
    }
}

