/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.auth;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.auth.AuthPolicy;
import alluxio.grpc.SetAttributePOptions;
import alluxio.jnifuse.FuseFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchUserGroupAuthPolicy
implements AuthPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(LaunchUserGroupAuthPolicy.class);
    protected final FileSystem mFileSystem;
    protected final Optional<FuseFileSystem> mFuseFileSystem;
    private final LoadingCache<Long, Optional<String>> mUsernameCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<Long, Optional<String>>(){

        public Optional<String> load(Long uid) {
            return AlluxioFuseUtils.getUserName(uid);
        }
    });
    private final LoadingCache<Long, Optional<String>> mGroupnameCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<Long, Optional<String>>(){

        public Optional<String> load(Long gid) {
            return AlluxioFuseUtils.getGroupName(gid);
        }
    });
    private long mLaunchUserId;
    private long mLaunchGroupId;

    public static LaunchUserGroupAuthPolicy create(FileSystem fileSystem, AlluxioConfiguration conf, Optional<FuseFileSystem> fuseFileSystem) {
        return new LaunchUserGroupAuthPolicy(fileSystem, fuseFileSystem);
    }

    protected LaunchUserGroupAuthPolicy(FileSystem fileSystem, Optional<FuseFileSystem> fuseFileSystem) {
        this.mFileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem);
        this.mFuseFileSystem = (Optional)Preconditions.checkNotNull(fuseFileSystem);
    }

    @Override
    public void init() {
        this.mLaunchUserId = AlluxioFuseUtils.getSystemUid();
        this.mLaunchGroupId = AlluxioFuseUtils.getSystemGid();
        LOG.info("Initialized Fuse auth policy with launch user (id:{}) and group (id:{})", (Object)this.mLaunchUserId, (Object)this.mLaunchGroupId);
    }

    @Override
    public void setUserGroupIfNeeded(AlluxioURI uri) {
    }

    @Override
    public void setUserGroup(AlluxioURI uri, long uid, long gid) {
        if (uid == this.mLaunchUserId && gid == this.mLaunchGroupId) {
            return;
        }
        Optional<URIStatus> status = AlluxioFuseUtils.getPathStatus(this.mFileSystem, uri);
        try {
            if (status.isPresent() && ((Optional)this.mUsernameCache.get((Object)uid)).isPresent() && ((Optional)this.mGroupnameCache.get((Object)gid)).isPresent() && status.get().getOwner().equals(((Optional)this.mUsernameCache.get((Object)uid)).get()) && status.get().getGroup().equals(((Optional)this.mGroupnameCache.get((Object)gid)).get())) {
                return;
            }
            SetAttributePOptions.Builder attributeBuilder = SetAttributePOptions.newBuilder();
            ((Optional)this.mUsernameCache.get((Object)uid)).ifPresent(arg_0 -> ((SetAttributePOptions.Builder)attributeBuilder).setOwner(arg_0));
            ((Optional)this.mGroupnameCache.get((Object)gid)).ifPresent(arg_0 -> ((SetAttributePOptions.Builder)attributeBuilder).setGroup(arg_0));
            SetAttributePOptions attributeOptions = attributeBuilder.build();
            LOG.debug("Setting attributes of path {} to {}", (Object)uri, (Object)attributeOptions);
            this.mFileSystem.setAttribute(uri, attributeOptions);
        }
        catch (AlluxioException | IOException | ExecutionException e) {
            throw AlluxioRuntimeException.from((Throwable)e);
        }
    }

    @Override
    public Optional<Long> getUid() {
        return Optional.of(this.mLaunchUserId);
    }

    @Override
    public Optional<Long> getGid() {
        return Optional.of(this.mLaunchGroupId);
    }
}

