/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.file;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.concurrent.LockMode;
import alluxio.exception.AlluxioException;
import alluxio.exception.PreconditionMessage;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.exception.runtime.FailedPreconditionRuntimeException;
import alluxio.exception.runtime.NotFoundRuntimeException;
import alluxio.exception.runtime.UnimplementedRuntimeException;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.file.FileStatus;
import alluxio.fuse.file.FuseFileStream;
import alluxio.fuse.lock.FuseReadWriteLockManager;
import alluxio.resource.CloseableResource;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FuseFileInStream
implements FuseFileStream {
    private final FileInStream mInStream;
    private final FileStatus mFileStatus;
    private final AlluxioURI mURI;
    private final CloseableResource<Lock> mLockResource;
    private volatile boolean mClosed = false;

    public static FuseFileInStream create(FileSystem fileSystem, FuseReadWriteLockManager lockManager, AlluxioURI uri) {
        Preconditions.checkNotNull((Object)fileSystem);
        Preconditions.checkNotNull((Object)uri);
        CloseableResource<Lock> lockResource = lockManager.tryLock(uri.toString(), LockMode.READ);
        try {
            Optional<URIStatus> status = AlluxioFuseUtils.getPathStatus(fileSystem, uri);
            if (status.isPresent() && !status.get().isCompleted() && !(status = AlluxioFuseUtils.waitForFileCompleted(fileSystem, uri)).isPresent()) {
                throw new UnimplementedRuntimeException(String.format("Failed to create fuse file in stream for %s: file is being written", uri));
            }
            if (!status.isPresent()) {
                throw new NotFoundRuntimeException(String.format("Failed to create read-only stream for %s: file does not exist", uri));
            }
            try {
                FileInStream is = fileSystem.openFile(uri);
                return new FuseFileInStream(is, lockResource, new FileStatus(status.get().getLength()), uri);
            }
            catch (AlluxioException | IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable t) {
            lockResource.close();
            throw t;
        }
    }

    private FuseFileInStream(FileInStream inStream, CloseableResource<Lock> lockResource, FileStatus fileStatus, AlluxioURI uri) {
        this.mInStream = (FileInStream)Preconditions.checkNotNull((Object)inStream);
        this.mLockResource = (CloseableResource)Preconditions.checkNotNull(lockResource);
        this.mFileStatus = (FileStatus)Preconditions.checkNotNull((Object)fileStatus);
        this.mURI = (AlluxioURI)Preconditions.checkNotNull((Object)uri);
    }

    @Override
    public synchronized int read(ByteBuffer buf, long size, long offset) {
        Preconditions.checkArgument((size >= 0L && offset >= 0L && size <= (long)buf.capacity() ? 1 : 0) != 0, (String)PreconditionMessage.ERR_BUFFER_STATE.toString(), (Object)buf.capacity(), (Object)offset, (Object)size);
        if (size == 0L) {
            return 0;
        }
        if (offset >= this.mFileStatus.getFileLength()) {
            return 0;
        }
        int sz = (int)size;
        int totalRead = 0;
        int currentRead = 0;
        try {
            this.mInStream.seek(offset);
            while (currentRead >= 0 && totalRead < sz) {
                currentRead = this.mInStream.read(buf, totalRead, sz - totalRead);
                if (currentRead <= 0) continue;
                totalRead += currentRead;
            }
        }
        catch (IOException e) {
            throw AlluxioRuntimeException.from((IOException)e);
        }
        return totalRead;
    }

    @Override
    public void write(ByteBuffer buf, long size, long offset) {
        throw new FailedPreconditionRuntimeException(String.format("Cannot write to read-only stream of path %s", this.mURI));
    }

    @Override
    public FileStatus getFileStatus() {
        return this.mFileStatus;
    }

    @Override
    public void flush() {
    }

    @Override
    public void truncate(long size) {
        throw new UnimplementedRuntimeException(String.format("Cannot truncate read-only stream of path %s", this.mURI));
    }

    @Override
    public synchronized void close() {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        try {
            this.mInStream.close();
        }
        catch (IOException e) {
            throw AlluxioRuntimeException.from((IOException)e);
        }
        finally {
            this.mLockResource.close();
        }
    }
}

