/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.command;

import alluxio.cli.Command;
import alluxio.cli.command.AbstractFuseShellCommand;
import alluxio.cli.command.metadatacache.DropAllCommand;
import alluxio.cli.command.metadatacache.DropCommand;
import alluxio.cli.command.metadatacache.SizeCommand;
import alluxio.client.file.FileSystem;
import alluxio.collections.TwoKeyConcurrentMap;
import alluxio.conf.AlluxioConfiguration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MetadataCacheCommand
extends AbstractFuseShellCommand {
    private static final Map<String, TwoKeyConcurrentMap.TriFunction<FileSystem, AlluxioConfiguration, String, ? extends Command>> SUB_COMMANDS = new HashMap<String, TwoKeyConcurrentMap.TriFunction<FileSystem, AlluxioConfiguration, String, ? extends Command>>();
    private final Map<String, Command> mSubCommands = new HashMap<String, Command>();

    public MetadataCacheCommand(FileSystem fs, AlluxioConfiguration conf) {
        super(fs, conf, "");
        SUB_COMMANDS.forEach((name, constructor) -> this.mSubCommands.put((String)name, (Command)constructor.apply((Object)fs, (Object)conf, (Object)this.getCommandName())));
    }

    public Map<String, Command> getSubCommands() {
        return this.mSubCommands;
    }

    public String getCommandName() {
        return "metadatacache";
    }

    public String getUsage() {
        StringBuilder usage = new StringBuilder("ls -l /mnt/alluxio-fuse/.alluxiocli." + this.getCommandName() + ".(");
        for (String cmd : SUB_COMMANDS.keySet()) {
            usage.append(cmd).append("|");
        }
        usage.deleteCharAt(usage.length() - 1).append(')');
        return usage.toString();
    }

    public String getDescription() {
        return "Metadatacache command is used to drop metadata cache or get cache size.";
    }

    static {
        SUB_COMMANDS.put("dropAll", (TwoKeyConcurrentMap.TriFunction<FileSystem, AlluxioConfiguration, String, ? extends Command>)((TwoKeyConcurrentMap.TriFunction)DropAllCommand::new));
        SUB_COMMANDS.put("drop", (TwoKeyConcurrentMap.TriFunction<FileSystem, AlluxioConfiguration, String, ? extends Command>)((TwoKeyConcurrentMap.TriFunction)DropCommand::new));
        SUB_COMMANDS.put("size", (TwoKeyConcurrentMap.TriFunction<FileSystem, AlluxioConfiguration, String, ? extends Command>)((TwoKeyConcurrentMap.TriFunction)SizeCommand::new));
    }
}

