/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.command.metadatacache;

import alluxio.AlluxioURI;
import alluxio.cli.command.AbstractFuseShellCommand;
import alluxio.client.file.FileSystem;
import alluxio.client.file.MetadataCachingFileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.LocalCacheFileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.runtime.InvalidArgumentRuntimeException;
import alluxio.exception.status.InvalidArgumentException;

public abstract class AbstractMetadataCacheSubCommand
extends AbstractFuseShellCommand {
    public AbstractMetadataCacheSubCommand(FileSystem fileSystem, AlluxioConfiguration conf, String commandName) {
        super(fileSystem, conf, commandName);
    }

    @Override
    public URIStatus run(AlluxioURI path, String[] argv) throws InvalidArgumentException {
        if (!this.mConf.getBoolean(PropertyKey.USER_METADATA_CACHE_ENABLED)) {
            throw new InvalidArgumentRuntimeException(String.format("%s command is not supported when %s is false", this.getCommandName(), PropertyKey.USER_METADATA_CACHE_ENABLED.getName()));
        }
        return this.runSubCommand(path, argv, this.findMetadataCachingFileSystem());
    }

    protected abstract URIStatus runSubCommand(AlluxioURI var1, String[] var2, MetadataCachingFileSystem var3);

    private MetadataCachingFileSystem findMetadataCachingFileSystem() {
        if (this.mFileSystem instanceof MetadataCachingFileSystem) {
            return (MetadataCachingFileSystem)this.mFileSystem;
        }
        if (this.mFileSystem instanceof LocalCacheFileSystem) {
            FileSystem underlyingFileSystem = ((LocalCacheFileSystem)this.mFileSystem).getUnderlyingFileSystem();
            if (underlyingFileSystem instanceof MetadataCachingFileSystem) {
                return (MetadataCachingFileSystem)underlyingFileSystem;
            }
            throw new IllegalStateException("The expected underlying FileSystem of LocalCacheFileSystem is MetadataCachingFileSystem, but found " + this.mFileSystem.getClass().getSimpleName());
        }
        throw new IllegalStateException(String.format("The expected FileSystem is %s or %s, but found %s", MetadataCachingFileSystem.class.getSimpleName(), LocalCacheFileSystem.class.getSimpleName(), this.mFileSystem.getClass().getSimpleName()));
    }
}

