/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse;

import alluxio.fuse.AlluxioFuseUtils;
import alluxio.jnifuse.AbstractFuseFileSystem;
import alluxio.jnifuse.ErrorCodes;
import alluxio.jnifuse.FuseFillDir;
import alluxio.jnifuse.struct.FileStat;
import alluxio.jnifuse.struct.FuseFileInfo;
import alluxio.jnifuse.struct.Statvfs;
import alluxio.metrics.MetricsSystem;
import alluxio.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackFS
extends AbstractFuseFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(StackFS.class);
    private static final long ID_NOT_SET_VALUE = -1L;
    private static final long ID_NOT_SET_VALUE_UNSIGNED = 0xFFFFFFFFL;
    private final Path mRoot;

    public StackFS(Path root, Path mountPoint) {
        super(mountPoint);
        this.mRoot = root;
    }

    private String transformPath(String path) {
        return this.mRoot + path;
    }

    private int getMode(Path path) throws IOException {
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
        int mode = FileUtils.translatePosixPermissionToMode(permissions);
        mode = Files.isDirectory(path, new LinkOption[0]) ? (mode |= 0x4000) : (mode |= 0x8000);
        return mode;
    }

    public int getattr(String path, FileStat stat) {
        return AlluxioFuseUtils.call(LOG, () -> this.getattrInternal(path, stat), "Stackfs.Getattr", "path=%s", path);
    }

    private int getattrInternal(String path, FileStat stat) {
        path = this.transformPath(path);
        try {
            Path filePath = Paths.get(path, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                return -ErrorCodes.ENOENT();
            }
            BasicFileAttributes attributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
            stat.st_size.set((Number)attributes.size());
            stat.st_blksize.set((long)((int)Math.ceil((double)attributes.size() / 512.0)));
            stat.st_ctim.tv_sec.set(attributes.creationTime().to(TimeUnit.SECONDS));
            stat.st_ctim.tv_nsec.set((Number)attributes.creationTime().to(TimeUnit.NANOSECONDS));
            stat.st_mtim.tv_sec.set(attributes.lastModifiedTime().to(TimeUnit.SECONDS));
            stat.st_mtim.tv_nsec.set((Number)attributes.lastModifiedTime().to(TimeUnit.NANOSECONDS));
            int uid = (Integer)Files.getAttribute(filePath, "unix:uid", new LinkOption[0]);
            int gid = (Integer)Files.getAttribute(filePath, "unix:gid", new LinkOption[0]);
            stat.st_uid.set((long)uid);
            stat.st_gid.set((long)gid);
            int mode = this.getMode(filePath);
            stat.st_mode.set((Number)mode);
        }
        catch (Exception e) {
            LOG.error("Failed to getattr {}", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
        return 0;
    }

    public int readdir(String path, long buff, long filter, long offset, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.readdirInternal(path, buff, filter, offset, fi), "Stackfs.Readdir", "path=%s,buf=%s", path, buff);
    }

    private int readdirInternal(String path, long buff, long filter, long offset, FuseFileInfo fi) {
        path = this.transformPath(path);
        File dir = new File(path);
        FuseFillDir.apply((long)filter, (long)buff, (String)".", null, (long)0L);
        FuseFillDir.apply((long)filter, (long)buff, (String)"..", null, (long)0L);
        File[] subfiles = dir.listFiles();
        if (subfiles != null) {
            for (File subfile : subfiles) {
                FuseFillDir.apply((long)filter, (long)buff, (String)subfile.getName(), null, (long)0L);
            }
        }
        return 0;
    }

    public int open(String path, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.openInternal(path, fi), "Stackfs.Open", "path=%s", path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int openInternal(String path, FuseFileInfo fi) {
        path = this.transformPath(path);
        try (FileInputStream fis = new FileInputStream(path);){
            int n = 0;
            return n;
        }
        catch (Exception e) {
            LOG.error("Failed to open {}", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int read(String path, ByteBuffer buf, long size, long offset, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.readInternal(path, buf, size, offset, fi), "Stackfs.Read", "path=%s,buf=%s,size=%d,offset=%d", path, buf, size, offset);
    }

    private int readInternal(String path, ByteBuffer buf, long size, long offset, FuseFileInfo fi) {
        MetricsSystem.counter((String)"Stackfs.BytesToRead").inc(size);
        path = this.transformPath(path);
        int sz = (int)size;
        int nread = 0;
        byte[] tmpbuf = new byte[sz];
        try (FileInputStream fis = new FileInputStream(path);){
            long nskipped = fis.skip(offset);
            int rd = 0;
            while (rd >= 0 && nread < sz) {
                rd = fis.read(tmpbuf, nread, sz - nread);
                if (rd < 0) continue;
                nread += rd;
            }
            buf.put(tmpbuf, 0, nread);
        }
        catch (IndexOutOfBoundsException e) {
            return 0;
        }
        catch (Exception e) {
            LOG.error("Failed to read {}", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
        MetricsSystem.counter((String)"Stackfs.BytesRead").inc((long)nread);
        return nread;
    }

    public int create(String path, long mode, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.createInternal(path, mode, fi), "Stackfs.Create", "path=%s,mode=%o", path, mode);
    }

    private int createInternal(String path, long mode, FuseFileInfo fi) {
        Path filePath = Paths.get(path = this.transformPath(path), new String[0]);
        if (Files.exists(filePath, new LinkOption[0])) {
            LOG.error("File {} already exist", (Object)path);
            return -ErrorCodes.EEXIST();
        }
        try {
            Files.createFile(filePath, new FileAttribute[0]);
            return 0;
        }
        catch (IOException e) {
            LOG.error("Failed to create {}", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int write(String path, ByteBuffer buf, long size, long offset, FuseFileInfo fi) {
        return AlluxioFuseUtils.call(LOG, () -> this.writeInternal(path, buf, size, offset, fi), "Stackfs.Write", "path=%s,buf=%s,size=%d,offset=%d", path, buf, size, offset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int writeInternal(String path, ByteBuffer buf, long size, long offset, FuseFileInfo fi) {
        path = this.transformPath(path);
        int sz = (int)size;
        try (FileOutputStream outputStream = new FileOutputStream(path);){
            byte[] dest = new byte[sz];
            buf.get(dest, 0, sz);
            outputStream.write(dest);
            MetricsSystem.counter((String)"Stackfs.BytesWritten").inc((long)sz);
            int n = sz;
            return n;
        }
        catch (IOException e) {
            LOG.error("Failed to write to {}", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int mkdir(String path, long mode) {
        return AlluxioFuseUtils.call(LOG, () -> this.mkdirInternal(path, mode), "Stackfs.Mkdir", "path=%s,mode=%o,", path, mode);
    }

    private int mkdirInternal(String path, long mode) {
        Path dirPath = Paths.get(path = this.transformPath(path), new String[0]);
        if (Files.exists(dirPath, new LinkOption[0])) {
            LOG.error("Dir {} already exist", (Object)path);
            return -ErrorCodes.EEXIST();
        }
        try {
            Files.createDirectory(dirPath, new FileAttribute[0]);
            return 0;
        }
        catch (IOException e) {
            LOG.error("Failed to mkdir {}", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int rmdir(String path) {
        Path filePath = Paths.get(path = this.transformPath(path), new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return -ErrorCodes.ENOENT();
        }
        try {
            FileUtils.deletePathRecursively((String)path);
            return 0;
        }
        catch (IOException e) {
            LOG.error("Failed to rmdir {}", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int statfs(String path, Statvfs stbuf) {
        long totalCapabilty = 0x10000000000L;
        long free = totalCapabilty / 2L;
        long blockSize = 16384L;
        stbuf.f_bsize.set((Number)blockSize);
        stbuf.f_frsize.set((Number)blockSize);
        stbuf.f_blocks.set((Number)(totalCapabilty / blockSize));
        long freeBlocks = free / blockSize;
        stbuf.f_bfree.set((Number)freeBlocks);
        stbuf.f_bavail.set((Number)freeBlocks);
        stbuf.f_files.set((Number)-1);
        stbuf.f_ffree.set((Number)-1);
        stbuf.f_favail.set((Number)-1);
        stbuf.f_namemax.set((Number)255);
        return 0;
    }

    public int unlink(String path) {
        return AlluxioFuseUtils.call(LOG, () -> this.unlinkInternal(path), "Stackfs.Unlink", "path=%s", path);
    }

    private int unlinkInternal(String path) {
        Path filePath = Paths.get(path = this.transformPath(path), new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return -ErrorCodes.ENOENT();
        }
        try {
            Files.delete(filePath);
            return 0;
        }
        catch (IOException e) {
            LOG.error("Failed to unlink {}", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int utimens(String path, long aSec, long aNsec, long mSec, long mNsec) {
        LOG.debug("utimens for {}, but do nothing for this filesystem", (Object)path);
        return 0;
    }

    public int rename(String oldPath, String newPath, int flags) {
        return AlluxioFuseUtils.call(LOG, () -> this.renameInternal(oldPath, newPath), "Stackfs.Rename", "oldPath=%s,newPath=%s,", oldPath, newPath);
    }

    private int renameInternal(String oldPath, String newPath) {
        oldPath = this.transformPath(oldPath);
        newPath = this.transformPath(newPath);
        Path oldFilePath = Paths.get(oldPath, new String[0]);
        Path newFilePath = Paths.get(newPath, new String[0]);
        if (!Files.exists(oldFilePath, new LinkOption[0])) {
            LOG.error("Old path {} does not exist", (Object)oldPath);
            return -ErrorCodes.ENOENT();
        }
        if (Files.exists(newFilePath, new LinkOption[0])) {
            LOG.error("New path {} does not exist", (Object)newPath);
            return -ErrorCodes.ENOENT();
        }
        try {
            Files.move(oldFilePath, newFilePath, new CopyOption[0]);
            return 0;
        }
        catch (IOException e) {
            LOG.error("Failed to move {} to {}", new Object[]{oldFilePath, newFilePath, e});
            return -ErrorCodes.EIO();
        }
    }

    public int chmod(String path, long mode) {
        return AlluxioFuseUtils.call(LOG, () -> this.chmodInternal(path, mode), "Stackfs.Chmod", "path=%s,mode=%o", path, mode);
    }

    private int chmodInternal(String path, long mode) {
        Path filePath = Paths.get(path = this.transformPath(path), new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return -ErrorCodes.ENOENT();
        }
        try {
            Files.setPosixFilePermissions(filePath, FileUtils.translateModeToPosixPermissions((int)((int)mode)));
            return 0;
        }
        catch (IOException e) {
            LOG.error("Failed to chmod {}", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int chown(String path, long uid, long gid) {
        return AlluxioFuseUtils.call(LOG, () -> this.chownInternal(path, uid, gid), "Stackfs.Chown", "path=%s,uid=%d,gid=%d", path, uid, gid);
    }

    private int chownInternal(String path, long uid, long gid) {
        Path filePath = Paths.get(path = this.transformPath(path), new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return -ErrorCodes.ENOENT();
        }
        try {
            Optional<String> groupName;
            UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
            PosixFileAttributeView view = Files.getFileAttributeView(filePath, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            Optional<String> userName = AlluxioFuseUtils.getUserName(uid);
            if (userName.isPresent()) {
                view.setOwner(lookupService.lookupPrincipalByName(userName.get()));
            }
            if ((groupName = AlluxioFuseUtils.getGroupName(gid)).isPresent()) {
                view.setGroup(lookupService.lookupPrincipalByGroupName(groupName.get()));
            }
            return 0;
        }
        catch (IOException e) {
            LOG.error("Failed to chown {}", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int flush(String path, FuseFileInfo fi) {
        return 0;
    }

    public int release(String path, FuseFileInfo fi) {
        return 0;
    }

    public String getFileSystemName() {
        return "jnifuse-stackfs";
    }
}

