/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.lock;

import alluxio.concurrent.ClientRWLock;
import alluxio.concurrent.LockMode;
import alluxio.exception.runtime.CancelledRuntimeException;
import alluxio.exception.runtime.DeadlineExceededRuntimeException;
import alluxio.resource.CloseableResource;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

public class FuseReadWriteLockManager {
    private static final long TRY_LOCK_TIMEOUT = 20000L;
    private static final int MAX_READER_CONCURRENCY = 64;
    private final LoadingCache<String, ClientRWLock> mLockCache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<String, ClientRWLock>(){

        public ClientRWLock load(String key) {
            return new ClientRWLock(64);
        }
    });

    public CloseableResource<Lock> tryLock(String path, LockMode mode) {
        ClientRWLock pathLock = (ClientRWLock)this.mLockCache.getUnchecked((Object)this.getHashedKey(path));
        final Lock lock = mode == LockMode.READ ? pathLock.readLock() : pathLock.writeLock();
        try {
            if (!lock.tryLock(20000L, TimeUnit.MILLISECONDS)) {
                throw new DeadlineExceededRuntimeException(String.format("Failed to acquire lock for path %s after %s ms (LockMode: %s, lock reference count = %s)", path, 20000L, mode, pathLock.getReferenceCount()));
            }
            return new CloseableResource<Lock>(lock){

                public void closeResource() {
                    lock.unlock();
                }
            };
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancelledRuntimeException(String.format("Failed to acquire lock for path %s after %s ms: interrupted (LockMode: %s, lock reference count = %s)", path, 20000L, mode, pathLock.getReferenceCount()));
        }
    }

    private String getHashedKey(String key) {
        return Hashing.md5().hashString((CharSequence)key, StandardCharsets.UTF_8).toString();
    }
}

