/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.command.metadatacache;

import alluxio.AlluxioURI;
import alluxio.cli.command.metadatacache.AbstractMetadataCacheSubCommand;
import alluxio.client.file.FileSystem;
import alluxio.client.file.MetadataCachingFileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.wire.FileInfo;

public final class DropCommand
extends AbstractMetadataCacheSubCommand {
    public DropCommand(FileSystem fs, AlluxioConfiguration conf, String parentCommandName) {
        super(fs, conf, parentCommandName);
    }

    public String getCommandName() {
        return "drop";
    }

    public String getUsage() {
        return String.format("%s%s%s.%s.%s", "/mnt/alluxio-fuse", "/<path to be cleaned>", "/.alluxiocli", this.getParentCommandName(), this.getCommandName());
    }

    @Override
    protected URIStatus runSubCommand(AlluxioURI path, String[] argv, MetadataCachingFileSystem fileSystem) {
        fileSystem.dropMetadataCache(path);
        return new URIStatus(new FileInfo().setCompleted(true));
    }

    public String getDescription() {
        return "Clear the metadata cache of a path and its parents.If the given path is a directory, clear the metadata cache of all it's children recursively";
    }
}

