/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.auth;

import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.runtime.InvalidArgumentRuntimeException;
import alluxio.fuse.auth.AuthPolicy;
import alluxio.jnifuse.FuseFileSystem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;

public class AuthPolicyFactory {
    public static AuthPolicy create(FileSystem fileSystem, AlluxioConfiguration conf, FuseFileSystem fuseFileSystem) {
        Class authPolicyClazz = conf.getClass(PropertyKey.FUSE_AUTH_POLICY_CLASS);
        if (!AuthPolicy.class.isAssignableFrom(authPolicyClazz)) {
            throw new InvalidArgumentRuntimeException(String.format("Cannot configure %s to %s, policy description: %s", PropertyKey.FUSE_AUTH_POLICY_CLASS.getName(), authPolicyClazz, PropertyKey.FUSE_AUTH_POLICY_CLASS.getDescription()));
        }
        try {
            Class<AuthPolicy> subAuthPolicyClazz = authPolicyClazz.asSubclass(AuthPolicy.class);
            Method createMethod = subAuthPolicyClazz.getMethod("create", FileSystem.class, AlluxioConfiguration.class, Optional.class);
            AuthPolicy authPolicy = (AuthPolicy)createMethod.invoke(null, fileSystem, conf, Optional.of(fuseFileSystem));
            authPolicy.init();
            return authPolicy;
        }
        catch (ClassCastException e) {
            throw new InvalidArgumentRuntimeException(String.format("Cannot configure %s to %s, policy description: %s", PropertyKey.FUSE_AUTH_POLICY_CLASS.getName(), authPolicyClazz, PropertyKey.FUSE_AUTH_POLICY_CLASS.getDescription()), (Throwable)e);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ne) {
            throw new InvalidArgumentRuntimeException(String.format("Failed to create %s: should not be reached here", authPolicyClazz.getName()), (Throwable)ne);
        }
    }
}

