/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.file;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.fuse.auth.AuthPolicy;
import alluxio.fuse.file.FileStatus;
import alluxio.fuse.file.FuseFileInOrOutStream;
import alluxio.fuse.file.FuseFileInStream;
import alluxio.fuse.file.FuseFileOutStream;
import alluxio.fuse.lock.FuseReadWriteLockManager;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.ThreadSafe;
import jnr.constants.platform.OpenFlags;

public interface FuseFileStream
extends AutoCloseable {
    public int read(ByteBuffer var1, long var2, long var4);

    public void write(ByteBuffer var1, long var2, long var4);

    public FileStatus getFileStatus();

    public void flush();

    public void truncate(long var1);

    @Override
    public void close();

    @ThreadSafe
    public static class Factory {
        private final FuseReadWriteLockManager mLockManager = new FuseReadWriteLockManager();
        private final FileSystem mFileSystem;
        private final AuthPolicy mAuthPolicy;

        public Factory(FileSystem fileSystem, AuthPolicy authPolicy) {
            this.mFileSystem = fileSystem;
            this.mAuthPolicy = authPolicy;
        }

        public FuseFileStream create(AlluxioURI uri, int flags, long mode) {
            switch (OpenFlags.valueOf((long)(flags & OpenFlags.O_ACCMODE.intValue()))) {
                case O_RDONLY: {
                    return FuseFileInStream.create(this.mFileSystem, this.mLockManager, uri);
                }
                case O_WRONLY: {
                    return FuseFileOutStream.create(this.mFileSystem, this.mAuthPolicy, this.mLockManager, uri, flags, mode);
                }
            }
            return FuseFileInOrOutStream.create(this.mFileSystem, this.mAuthPolicy, this.mLockManager, uri, flags, mode);
        }
    }
}

