/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.meta;

import alluxio.check.UpdateCheck;
import alluxio.client.file.options.UfsFileSystemOptions;
import alluxio.fuse.FuseConstants;
import alluxio.fuse.options.FuseOptions;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.metrics.MetricsSystem;
import alluxio.util.URIUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class UpdateChecker
implements HeartbeatExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateChecker.class);
    static final String UNDERLYING_FS_FORMAT = "UnderlyingFileSystem:%s";
    static final String LOCAL_ALLUXIO_DATA_CACHE = "localAlluxioDataCache";
    static final String LOCAL_ALLUXIO_METADATA_CACHE = "localAlluxioMetadataCache";
    static final String LOCAL_KERNEL_DATA_CACHE = "localKernelDataCache";
    static final String ALLUXIO_FS = "alluxio";
    static final String LOCAL_FS = "local";
    private final String mInstanceId = UUID.randomUUID().toString();
    private final Map<String, Long> mFuseOpsCounter;
    private final List<String> mUnchangeableFuseInfo;

    public static UpdateChecker create(FuseOptions fuseOptions) {
        ArrayList<String> fuseInfo = new ArrayList<String>();
        UpdateCheck.addIfTrue((boolean)UpdateChecker.isLocalAlluxioDataCacheEnabled(fuseOptions), fuseInfo, (String)LOCAL_ALLUXIO_DATA_CACHE);
        UpdateCheck.addIfTrue((boolean)UpdateChecker.isLocalAlluxioMetadataCacheEnabled(fuseOptions), fuseInfo, (String)LOCAL_ALLUXIO_METADATA_CACHE);
        UpdateCheck.addIfTrue((boolean)UpdateChecker.isLocalKernelDataCacheEnabled(fuseOptions), fuseInfo, (String)LOCAL_KERNEL_DATA_CACHE);
        fuseInfo.add(String.format(UNDERLYING_FS_FORMAT, UpdateChecker.getUnderlyingFileSystem(fuseOptions)));
        return new UpdateChecker(Collections.unmodifiableList(fuseInfo), FuseConstants.getFuseMethodNames().stream().collect(Collectors.toMap(methodName -> methodName, methodName -> 0L)));
    }

    private UpdateChecker(List<String> unchangeableFuseInfo, Map<String, Long> fuseOpsCounter) {
        this.mUnchangeableFuseInfo = unchangeableFuseInfo;
        this.mFuseOpsCounter = fuseOpsCounter;
    }

    public void heartbeat(long timeLimitMs) {
        try {
            String latestVersion = UpdateCheck.getLatestVersion((String)this.mInstanceId, this.getFuseCheckInfo(), (long)3000L, (long)3000L, (long)3000L);
            if (!"2.9.5".equals(latestVersion)) {
                LOG.info("The latest version (" + latestVersion + ") is not the same as the current version (" + "2.9.5" + "). To upgrade visit https://www.alluxio.io/download/.");
            }
        }
        catch (Throwable t) {
            LOG.debug("Unable to check for updates:", t);
        }
    }

    public void close() {
    }

    @VisibleForTesting
    List<String> getFuseCheckInfo() {
        ArrayList<String> info = new ArrayList<String>(this.mUnchangeableFuseInfo);
        for (String fuseOps : this.mFuseOpsCounter.keySet()) {
            this.mFuseOpsCounter.computeIfPresent(fuseOps, (key, value) -> {
                long newCount = MetricsSystem.timer((String)key).getCount();
                if (newCount > value) {
                    info.add(fuseOps);
                }
                return newCount;
            });
        }
        return info;
    }

    @VisibleForTesting
    List<String> getUnchangeableFuseInfo() {
        return this.mUnchangeableFuseInfo;
    }

    private static boolean isLocalAlluxioDataCacheEnabled(FuseOptions fuseOptions) {
        return fuseOptions.getFileSystemOptions().isDataCacheEnabled();
    }

    private static boolean isLocalAlluxioMetadataCacheEnabled(FuseOptions fuseOptions) {
        return fuseOptions.getFileSystemOptions().isMetadataCacheEnabled();
    }

    private static boolean isLocalKernelDataCacheEnabled(FuseOptions fuseOptions) {
        return !fuseOptions.getFuseMountOptions().contains("direct_io");
    }

    private static String getUnderlyingFileSystem(FuseOptions fuseOptions) {
        if (!fuseOptions.getFileSystemOptions().getUfsFileSystemOptions().isPresent()) {
            return ALLUXIO_FS;
        }
        String ufsAddress = ((UfsFileSystemOptions)fuseOptions.getFileSystemOptions().getUfsFileSystemOptions().get()).getUfsAddress();
        if (URIUtils.isLocalFilesystem((String)ufsAddress)) {
            return LOCAL_FS;
        }
        String[] components = ufsAddress.split(":");
        if (components.length < 2) {
            return "unknown";
        }
        return components[0];
    }
}

