/*
 * Decompiled with CFR 0.152.
 */
package alluxio.jnifuse;

import alluxio.jnifuse.ErrorCodes;
import alluxio.jnifuse.FuseException;
import alluxio.jnifuse.FuseFileSystem;
import alluxio.jnifuse.LibFuse;
import alluxio.jnifuse.struct.FileStat;
import alluxio.jnifuse.struct.FuseContext;
import alluxio.jnifuse.struct.FuseFileInfo;
import alluxio.jnifuse.struct.Statvfs;
import alluxio.jnifuse.utils.SecurityUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFuseFileSystem
implements FuseFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFuseFileSystem.class);
    private static final int MOUNT_TIMEOUT_MS = 2000;
    private final LibFuse libFuse;
    private final AtomicBoolean mounted = new AtomicBoolean();
    private final Path mountPoint;

    public AbstractFuseFileSystem(Path mountPoint) {
        this.libFuse = new LibFuse();
        this.mountPoint = mountPoint.toAbsolutePath();
    }

    public void mount(boolean blocking, boolean debug, String[] fuseOpts) {
        if (!this.mounted.compareAndSet(false, true)) {
            throw new FuseException("Fuse File System already mounted!");
        }
        LOG.info("Mounting {}: blocking={}, debug={}, fuseOpts=\"{}\"", new Object[]{this.mountPoint, blocking, debug, Arrays.toString(fuseOpts)});
        String mountPointStr = this.mountPoint.toString();
        if (mountPointStr.endsWith("\\")) {
            mountPointStr = mountPointStr.substring(0, mountPointStr.length() - 1);
        }
        String[] arg = !debug ? new String[]{this.getFileSystemName(), "-f", mountPointStr} : new String[]{this.getFileSystemName(), "-f", "-d", mountPointStr};
        if (fuseOpts.length != 0) {
            int argLen = arg.length;
            arg = Arrays.copyOf(arg, argLen + fuseOpts.length);
            System.arraycopy(fuseOpts, 0, arg, argLen, fuseOpts.length);
        }
        String[] args = arg;
        try {
            int res;
            if (SecurityUtils.canHandleShutdownHooks()) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> this.umount(true)));
            }
            if (blocking) {
                res = this.execMount(args);
            } else {
                try {
                    res = CompletableFuture.supplyAsync(() -> this.execMount(args)).get(2000L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    res = 0;
                }
            }
            if (res != 0) {
                throw new FuseException("Unable to mount FS, return code = " + res);
            }
        }
        catch (Exception e) {
            this.mounted.set(false);
            throw new FuseException("Unable to mount FS", e);
        }
    }

    private int execMount(String[] arg) {
        return this.libFuse.fuse_main_real(this, arg.length, arg);
    }

    public void umount(boolean force) {
        if (!this.mounted.get()) {
            return;
        }
        LOG.info("Umounting {}", (Object)this.mountPoint);
        try {
            this.umountInternal();
        }
        catch (FuseException e) {
            LOG.error("Failed to umount {}", (Object)this.mountPoint, (Object)e);
            throw e;
        }
        this.mounted.set(false);
    }

    private void umountInternal() {
        int exitCode = 1;
        String mountPath = this.mountPoint.toString();
        if (!SystemUtils.IS_OS_WINDOWS) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                try {
                    exitCode = new ProcessBuilder("umount", "-f", mountPath).start().waitFor();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new FuseException("Unable to umount FS", ie);
                }
                catch (IOException ioe) {
                    throw new FuseException("Unable to umount FS", ioe);
                }
            }
            try {
                exitCode = new ProcessBuilder("fusermount", "-u", "-z", mountPath).start().waitFor();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                try {
                    exitCode = new ProcessBuilder("umount", mountPath).start().waitFor();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new FuseException("Unable to umount FS", e);
                }
                catch (IOException ioe) {
                    ioe.addSuppressed(e);
                    throw new FuseException("Unable to umount FS", ioe);
                }
            }
        }
        if (exitCode != 0) {
            throw new FuseException("Unable to umount FS with exit code " + exitCode);
        }
    }

    public int openCallback(String path, ByteBuffer buf) {
        try {
            return this.open(path, FuseFileInfo.of(buf));
        }
        catch (Exception e) {
            LOG.error("Failed to open {}: ", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int readCallback(String path, ByteBuffer buf, long size, long offset, ByteBuffer fibuf) {
        try {
            return this.read(path, buf, size, offset, FuseFileInfo.of(fibuf));
        }
        catch (Exception e) {
            LOG.error("Failed to read {}, size {}, offset {}: ", new Object[]{path, size, offset, e});
            return -ErrorCodes.EIO();
        }
    }

    public int getattrCallback(String path, ByteBuffer buf) {
        try {
            return this.getattr(path, FileStat.of(buf));
        }
        catch (Exception e) {
            LOG.error("Failed to getattr {}: ", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int readdirCallback(String path, long bufaddr, long filter, long offset, ByteBuffer fi) {
        try {
            return this.readdir(path, bufaddr, filter, offset, FuseFileInfo.of(fi));
        }
        catch (Exception e) {
            LOG.error("Failed to readdir {}, offset {}: ", new Object[]{path, offset, e});
            return -ErrorCodes.EIO();
        }
    }

    public int unlinkCallback(String path) {
        try {
            return this.unlink(path);
        }
        catch (Exception e) {
            LOG.error("Failed to unlink {}: ", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int flushCallback(String path, ByteBuffer fi) {
        try {
            return this.flush(path, FuseFileInfo.of(fi));
        }
        catch (Exception e) {
            LOG.error("Failed to flush {}: ", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int releaseCallback(String path, ByteBuffer fi) {
        try {
            return this.release(path, FuseFileInfo.of(fi));
        }
        catch (Exception e) {
            LOG.error("Failed to release {}: ", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int chmodCallback(String path, long mode) {
        try {
            return this.chmod(path, mode);
        }
        catch (Exception e) {
            LOG.error("Failed to chmod {}, mode {}: ", new Object[]{path, mode, e});
            return -ErrorCodes.EIO();
        }
    }

    public int chownCallback(String path, long uid, long gid) {
        try {
            return this.chown(path, uid, gid);
        }
        catch (Exception e) {
            LOG.error("Failed to chown {}, uid {}, gid {}: ", new Object[]{path, uid, gid, e});
            return -ErrorCodes.EIO();
        }
    }

    public int createCallback(String path, long mode, ByteBuffer fi) {
        try {
            return this.create(path, mode, FuseFileInfo.of(fi));
        }
        catch (Exception e) {
            LOG.error("Failed to create {}, mode {}: ", new Object[]{path, mode, e});
            return -ErrorCodes.EIO();
        }
    }

    public int mkdirCallback(String path, long mode) {
        try {
            return this.mkdir(path, mode);
        }
        catch (Exception e) {
            LOG.error("Failed to mkdir {}, mode {}: ", new Object[]{path, mode, e});
            return -ErrorCodes.EIO();
        }
    }

    public int renameCallback(String oldPath, String newPath) {
        try {
            return this.rename(oldPath, newPath);
        }
        catch (Exception e) {
            LOG.error("Failed to rename {}, newPath {}: ", new Object[]{oldPath, newPath, e});
            return -ErrorCodes.EIO();
        }
    }

    public int rmdirCallback(String path) {
        try {
            return this.rmdir(path);
        }
        catch (Exception e) {
            LOG.error("Failed to rmdir {}: ", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int statfsCallback(String path, ByteBuffer stbuf) {
        try {
            return this.statfs(path, Statvfs.of(stbuf));
        }
        catch (Exception e) {
            LOG.error("Failed to statfs {}: ", (Object)path, (Object)e);
            return -ErrorCodes.EIO();
        }
    }

    public int symlinkCallback(String linkname, String path) {
        try {
            return this.symlink(linkname, path);
        }
        catch (Exception e) {
            LOG.error("Failed to symlink linkname {}, path {}", new Object[]{linkname, path, e});
            return -ErrorCodes.EIO();
        }
    }

    public int truncateCallback(String path, long size) {
        try {
            return this.truncate(path, size);
        }
        catch (Exception e) {
            LOG.error("Failed to truncate {}, size {}: ", new Object[]{path, size, e});
            return -ErrorCodes.EIO();
        }
    }

    public int writeCallback(String path, ByteBuffer buf, long size, long offset, ByteBuffer fi) {
        try {
            return this.write(path, buf, size, offset, FuseFileInfo.of(fi));
        }
        catch (Exception e) {
            LOG.error("Failed to write {}, size {}, offset {}: ", new Object[]{path, size, offset, e});
            return -ErrorCodes.EIO();
        }
    }

    public int setxattrCallback(String path, String name, ByteBuffer value, long size, int flags) {
        return 0;
    }

    public int getxattrCallback(String path, String name, ByteBuffer value) {
        return 0;
    }

    public int listxattrCallback(String path, ByteBuffer list) {
        return 0;
    }

    public int removexattrCallback(String path, String name) {
        return 0;
    }

    @Override
    public FuseContext getContext() {
        ByteBuffer buffer = this.libFuse.fuse_get_context();
        return FuseContext.of(buffer);
    }

    static {
        LibFuse.loadLibrary();
    }
}

