/*
 * Decompiled with CFR 0.152.
 */
package alluxio.jnifuse;

import alluxio.jnifuse.AbstractFuseFileSystem;
import alluxio.jnifuse.utils.NativeLibraryLoader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;

public class LibFuse {
    private static AtomicReference<LibraryState> libraryLoaded = new AtomicReference<LibraryState>(LibraryState.NOT_LOADED);

    public native int fuse_main_real(AbstractFuseFileSystem var1, int var2, String[] var3);

    public native ByteBuffer fuse_get_context();

    public static void loadLibrary() {
        if (libraryLoaded.get() == LibraryState.LOADED) {
            return;
        }
        if (libraryLoaded.compareAndSet(LibraryState.NOT_LOADED, LibraryState.LOADING)) {
            String tmpDir = System.getenv("JNIFUSE_SHAREDLIB_DIR");
            try {
                NativeLibraryLoader.getInstance().loadLibrary(tmpDir);
            }
            catch (IOException e) {
                libraryLoaded.set(LibraryState.NOT_LOADED);
                throw new RuntimeException("Unable to load the jni-fuse shared library" + e);
            }
            libraryLoaded.set(LibraryState.LOADED);
            return;
        }
        while (libraryLoaded.get() == LibraryState.LOADING) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static {
        LibFuse.loadLibrary();
    }

    private static enum LibraryState {
        NOT_LOADED,
        LOADING,
        LOADED;

    }
}

