/*
 * Decompiled with CFR 0.152.
 */
package alluxio.jnifuse.utils;

import alluxio.jnifuse.utils.Environment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibraryLoader {
    private static final Logger LOG = LoggerFactory.getLogger(NativeLibraryLoader.class);
    private static final NativeLibraryLoader INSTANCE = new NativeLibraryLoader();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final String SHARED_LIBRARY_NAME = Environment.getSharedLibraryName("jnifuse");
    private static final String SHARED_LIBRARY_FILE_NAME = Environment.getSharedLibraryFileName("jnifuse");
    private static final String JNI_LIBRARY_NAME = Environment.getJniLibraryName("jnifuse");
    private static final String JNI_LIBRARY_FILE_NAME = Environment.getJniLibraryFileName("jnifuse");
    private static final String TEMP_FILE_PREFIX = "libjnifuse";
    private static final String TEMP_FILE_SUFFIX = Environment.getJniLibraryExtension();

    private static void setInitialized(boolean initialized) {
        INITIALIZED.set(initialized);
    }

    public static NativeLibraryLoader getInstance() {
        return INSTANCE;
    }

    public synchronized void loadLibrary(String tmpDir) throws IOException {
        try {
            System.loadLibrary(SHARED_LIBRARY_NAME);
            LOG.info("Loaded {} by System.loadLibrary.", (Object)SHARED_LIBRARY_NAME);
        }
        catch (UnsatisfiedLinkError ule1) {
            try {
                System.loadLibrary(JNI_LIBRARY_NAME);
                LOG.info("Loaded {} by System.loadLibrary.", (Object)JNI_LIBRARY_NAME);
            }
            catch (UnsatisfiedLinkError ule2) {
                this.loadLibraryFromJar(tmpDir);
            }
        }
    }

    void loadLibraryFromJar(String tmpDir) throws IOException {
        if (!INITIALIZED.get()) {
            String libPath = this.loadLibraryFromJarToTemp(tmpDir).getAbsolutePath();
            System.load(libPath);
            NativeLibraryLoader.setInitialized(true);
            LOG.info("Loaded lib by jar from path {}.", (Object)libPath);
        }
    }

    File loadLibraryFromJarToTemp(String tmpDir) throws IOException {
        File temp;
        if (tmpDir == null || tmpDir.isEmpty()) {
            temp = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        } else {
            temp = new File(tmpDir, JNI_LIBRARY_FILE_NAME);
            if (temp.exists() && !temp.delete()) {
                throw new RuntimeException("File: " + temp.getAbsolutePath() + " already exists and cannot be removed.");
            }
            if (!temp.createNewFile()) {
                throw new RuntimeException("File: " + temp.getAbsolutePath() + " could not be created.");
            }
        }
        if (!temp.exists()) {
            throw new RuntimeException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        temp.deleteOnExit();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(SHARED_LIBRARY_FILE_NAME);){
            if (is == null) {
                throw new RuntimeException(SHARED_LIBRARY_FILE_NAME + " was not found inside JAR.");
            }
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return temp;
    }

    private NativeLibraryLoader() {
    }
}

