/*
 * Decompiled with CFR 0.152.
 */
package alluxio.jnifuse;

import alluxio.jnifuse.struct.FileStat;
import alluxio.jnifuse.struct.FuseContext;
import alluxio.jnifuse.struct.FuseFileInfo;
import alluxio.jnifuse.struct.Statvfs;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;

public interface FuseFileSystem {
    default public int getattr(String path, FileStat stat) {
        throw new UnsupportedOperationException("getattr");
    }

    default public int mkdir(String path, long mode) {
        throw new UnsupportedOperationException("mkdir");
    }

    default public int unlink(String path) {
        throw new UnsupportedOperationException("unlink");
    }

    default public int rmdir(String path) {
        throw new UnsupportedOperationException("rmdir");
    }

    default public int symlink(String oldpath, String newpath) {
        throw new UnsupportedOperationException("symlink");
    }

    default public int rename(String oldpath, String newpath, int flags) {
        throw new UnsupportedOperationException("rename");
    }

    default public int link(String oldpath, String newpath) {
        throw new UnsupportedOperationException("link");
    }

    default public int chmod(String path, long mode) {
        throw new UnsupportedOperationException("chmod");
    }

    default public int chown(String path, long uid, long gid) {
        throw new UnsupportedOperationException("chown");
    }

    default public int truncate(String path, long size) {
        throw new UnsupportedOperationException("truncate");
    }

    default public int open(String path, FuseFileInfo fi) {
        throw new UnsupportedOperationException("open");
    }

    default public int read(String path, ByteBuffer buf, long size, long offset, FuseFileInfo fi) {
        throw new UnsupportedOperationException("read");
    }

    default public int write(String path, ByteBuffer buf, long size, long offset, FuseFileInfo fi) {
        throw new UnsupportedOperationException("write");
    }

    default public int statfs(String path, Statvfs stbuf) {
        throw new UnsupportedOperationException("statfs");
    }

    default public int flush(String path, FuseFileInfo fi) {
        throw new UnsupportedOperationException("flush");
    }

    default public int release(String path, FuseFileInfo fi) {
        throw new UnsupportedOperationException("release");
    }

    default public int opendir(String path, FuseFileInfo fi) {
        throw new UnsupportedOperationException("opendir");
    }

    default public int readdir(String path, long bufaddr, long filter, long offset, FuseFileInfo fi) {
        throw new UnsupportedOperationException("readdir");
    }

    default public int releasedir(String path, FuseFileInfo fi) {
        throw new UnsupportedOperationException("releasedir");
    }

    default public int create(String path, long mode, FuseFileInfo fi) {
        throw new UnsupportedOperationException("create");
    }

    default public int utimens(String path, long aSec, long aNsec, long mSec, long mNsec) {
        throw new UnsupportedOperationException("utimens");
    }

    default public FuseContext getContext() {
        return FuseContext.of(ByteBuffer.allocate(32));
    }

    default public String getFileSystemName() {
        return "fusefs" + ThreadLocalRandom.current().nextInt();
    }
}

