/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.ValidationTask;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationTool;
import alluxio.cli.ValidationUtils;
import alluxio.cli.hms.CreateHmsClientValidationTask;
import alluxio.cli.hms.DatabaseValidationTask;
import alluxio.cli.hms.TableValidationTask;
import alluxio.cli.hms.UriCheckTask;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmsValidationTool
implements ValidationTool {
    private static final Logger LOG = LoggerFactory.getLogger(HmsValidationTool.class);
    public static final int DEFAULT_SOCKET_TIMEOUT_MINUTES = 12;
    public static final String DEFAULT_DATABASE = "default";
    private final String mMetastoreUri;
    private final String mDatabase;
    private final String mTables;
    private final int mSocketTimeoutMinutes;
    private final Map<String, ValidationTask> mTasks;

    private HmsValidationTool(String metastoreUri, String database, String tables, int socketTimeout) {
        this.mMetastoreUri = metastoreUri;
        this.mDatabase = database == null || database.isEmpty() ? DEFAULT_DATABASE : database;
        this.mTables = tables;
        this.mSocketTimeoutMinutes = socketTimeout > 0 ? socketTimeout : 12;
        this.mTasks = new HashMap<String, ValidationTask>();
        UriCheckTask uriCheck = new UriCheckTask(this.mMetastoreUri, this.mSocketTimeoutMinutes * 60000);
        CreateHmsClientValidationTask clientTask = new CreateHmsClientValidationTask(this.mSocketTimeoutMinutes * 60, uriCheck);
        DatabaseValidationTask dbTask = new DatabaseValidationTask(this.mDatabase, clientTask);
        TableValidationTask tableTask = new TableValidationTask(this.mDatabase, this.mTables, clientTask);
        this.mTasks.put(uriCheck.getName(), (ValidationTask)uriCheck);
        this.mTasks.put(clientTask.getName(), (ValidationTask)clientTask);
        this.mTasks.put(dbTask.getName(), (ValidationTask)dbTask);
        this.mTasks.put(tableTask.getName(), (ValidationTask)tableTask);
    }

    public static HmsValidationTool create(Map<Object, Object> configMap) {
        String metastoreUri = "";
        String database = DEFAULT_DATABASE;
        String tables = "";
        int socketTimeout = 12;
        try {
            metastoreUri = (String)configMap.getOrDefault("metastore_uri", "");
            database = (String)configMap.getOrDefault("database", DEFAULT_DATABASE);
            tables = (String)configMap.getOrDefault("tables", "");
            socketTimeout = Integer.parseInt(configMap.getOrDefault("socket_timeout", 12).toString());
        }
        catch (RuntimeException e) {
            LOG.error("Failed to process hms validation tool config from config map {}", configMap, (Object)e);
        }
        return new HmsValidationTool(metastoreUri, database, tables, socketTimeout);
    }

    public Map<String, ValidationTask> getTasks() {
        return this.mTasks;
    }

    public List<ValidationTaskResult> runAllTests() {
        return this.mTasks.values().stream().map(t -> {
            try {
                return t.validate(new HashMap());
            }
            catch (InterruptedException e) {
                return new ValidationTaskResult(ValidationUtils.State.FAILED, t.getName(), "Task interrupted while running", "");
            }
        }).collect(Collectors.toList());
    }
}

