/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.hms;

import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.cli.hms.MetastoreValidationTask;
import alluxio.collections.Pair;
import alluxio.util.ExceptionUtils;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.security.UserGroupInformation;

public class CreateHmsClientValidationTask
extends MetastoreValidationTask<String, IMetaStoreClient> {
    private final int mSocketTimeoutSeconds;

    public CreateHmsClientValidationTask(int socketTimeout, MetastoreValidationTask<?, String> input) {
        super(input);
        this.mSocketTimeoutSeconds = socketTimeout;
    }

    public String getName() {
        return "CreateHmsClientTest";
    }

    @Override
    public ValidationTaskResult validateImpl(Map<String, String> optionMap) throws InterruptedException {
        Pair<ValidationTaskResult, IMetaStoreClient> ent = this.getValidationWithResult();
        if (ent.getFirst() == null) {
            ((IMetaStoreClient)ent.getSecond()).close();
            return new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), "Metastore connection successful", "");
        }
        return (ValidationTaskResult)ent.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Pair<ValidationTaskResult, IMetaStoreClient> getValidationWithResult() throws InterruptedException {
        if (this.mInputTask == null) {
            return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), "pre-requisite check on metastore URI failed.", ""), null);
        }
        Pair inputResult = this.mInputTask.getValidationWithResult();
        if (((ValidationTaskResult)inputResult.getFirst()).getState() != ValidationUtils.State.OK) {
            return new Pair(inputResult.getFirst(), null);
        }
        String metastoreUri = (String)inputResult.getSecond();
        try {
            ConnectHmsAction action;
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                HiveConf conf = new HiveConf();
                conf.setVar(HiveConf.ConfVars.METASTOREURIS, metastoreUri);
                conf.setIntVar(HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT, this.mSocketTimeoutSeconds);
                action = new ConnectHmsAction(conf);
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                ugi.doAs((PrivilegedExceptionAction)action);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), "Metastore connection successful", ""), (Object)action.getConnection());
        }
        catch (UndeclaredThrowableException e) {
            if (e.getUndeclaredThrowable() instanceof IMetaStoreClient.IncompatibleMetastoreException) {
                return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), ExceptionUtils.asPlainText((Throwable)e), String.format("Hive metastore client (version: %s) is incompatible with your Hive Metastore server version", IMetaStoreClient.class.getPackage().getImplementationVersion())), null);
            }
            return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), ExceptionUtils.asPlainText((Throwable)e), "Failed to create hive metastore client. Please check if the given hive metastore uris is valid and reachable"), null);
        }
        catch (InterruptedException e) {
            return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), ExceptionUtils.asPlainText((Throwable)e), "Hive metastore client creation is interrupted. Please rerun the test if needed"), null);
        }
        catch (Throwable t) {
            String errorInfo = ExceptionUtils.asPlainText((Throwable)t);
            ValidationTaskResult result = new ValidationTaskResult().setState(ValidationUtils.State.FAILED).setName(this.getName()).setOutput(errorInfo);
            if (errorInfo.contains("Could not connect to meta store using any of the URIs provided")) {
                result.setAdvice("Failed to create hive metastore client. Please check if the given hive metastore uri(s) is valid and reachable");
            } else {
                result.setAdvice("Failed to create hive metastore client");
            }
            return new Pair((Object)result, null);
        }
    }

    static class ConnectHmsAction
    implements PrivilegedExceptionAction<Void> {
        private IMetaStoreClient mConnection;
        private final HiveConf mHiveConf;

        public ConnectHmsAction(HiveConf conf) {
            this.mHiveConf = conf;
        }

        public IMetaStoreClient getConnection() {
            return this.mConnection;
        }

        @Override
        public Void run() throws MetaException {
            this.mConnection = RetryingMetaStoreClient.getProxy((Configuration)this.mHiveConf, table -> null, (String)HiveMetaStoreClient.class.getName());
            return null;
        }
    }
}

