/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.replicate;

import alluxio.AlluxioURI;
import alluxio.client.job.JobMasterClient;
import alluxio.client.job.JobMasterClientPool;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.NotFoundException;
import alluxio.grpc.ListAllPOptions;
import alluxio.job.JobConfig;
import alluxio.job.plan.replicate.EvictConfig;
import alluxio.job.plan.replicate.MoveConfig;
import alluxio.job.plan.replicate.ReplicateConfig;
import alluxio.job.plan.replicate.ReplicationHandler;
import alluxio.job.wire.Status;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DefaultReplicationHandler
implements ReplicationHandler {
    private final JobMasterClientPool mJobMasterClientPool;

    public DefaultReplicationHandler(JobMasterClientPool jobMasterClientPool) {
        this.mJobMasterClientPool = jobMasterClientPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status getJobStatus(long jobId) throws IOException {
        JobMasterClient client = (JobMasterClient)this.mJobMasterClientPool.acquire();
        try {
            Status status = client.getJobStatus(jobId).getStatus();
            return status;
        }
        catch (NotFoundException e) {
            Status status = Status.FAILED;
            return status;
        }
        finally {
            this.mJobMasterClientPool.release(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> findJobs(String jobName, Set<Status> status) throws IOException {
        JobMasterClient client = (JobMasterClient)this.mJobMasterClientPool.acquire();
        try {
            List<Long> list = client.list(ListAllPOptions.newBuilder().setName(jobName).addAllStatus((Iterable)status.stream().map(Status::toProto).collect(Collectors.toSet())).build());
            return list;
        }
        finally {
            this.mJobMasterClientPool.release(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long evict(AlluxioURI uri, long blockId, int numReplicas) throws AlluxioException, IOException {
        JobMasterClient client = (JobMasterClient)this.mJobMasterClientPool.acquire();
        try {
            long l = client.run((JobConfig)new EvictConfig(uri.getPath(), blockId, numReplicas));
            return l;
        }
        finally {
            this.mJobMasterClientPool.release(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long replicate(AlluxioURI uri, long blockId, int numReplicas) throws AlluxioException, IOException {
        JobMasterClient client = (JobMasterClient)this.mJobMasterClientPool.acquire();
        try {
            long l = client.run((JobConfig)new ReplicateConfig(uri.getPath(), blockId, numReplicas));
            return l;
        }
        finally {
            this.mJobMasterClientPool.release(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long migrate(AlluxioURI uri, long blockId, String workerHost, String mediumType) throws AlluxioException, IOException {
        JobMasterClient client = (JobMasterClient)this.mJobMasterClientPool.acquire();
        try {
            long l = client.run((JobConfig)new MoveConfig(uri.getPath(), blockId, workerHost, mediumType));
            return l;
        }
        finally {
            this.mJobMasterClientPool.release(client);
        }
    }
}

