/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.job;

import alluxio.ClientContext;
import alluxio.client.job.JobMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.job.JobConfig;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.retry.CountingRetry;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.worker.job.JobMasterClientContext;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JobGrpcClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JobGrpcClientUtils.class);

    public static JobInfo getJobStatus(long jobId, AlluxioConfiguration alluxioConf, boolean verbose) throws IOException {
        try (JobMasterClient client = JobMasterClient.Factory.create(JobMasterClientContext.newBuilder(ClientContext.create((AlluxioConfiguration)alluxioConf)).build());){
            if (verbose) {
                JobInfo jobInfo = client.getJobStatusDetailed(jobId);
                return jobInfo;
            }
            JobInfo jobInfo = client.getJobStatus(jobId);
            return jobInfo;
        }
    }

    public static long run(JobConfig config, int attempts, AlluxioConfiguration alluxioConf) throws InterruptedException {
        CountingRetry retryPolicy = new CountingRetry(attempts);
        String errorMessage = "";
        while (retryPolicy.attempt()) {
            long jobId;
            try (JobMasterClient client = JobMasterClient.Factory.create(JobMasterClientContext.newBuilder(ClientContext.create((AlluxioConfiguration)alluxioConf)).build());){
                jobId = client.run(config);
            }
            catch (Exception e) {
                LOG.warn("Exception encountered when starting a job.", (Throwable)e);
                continue;
            }
            JobInfo jobInfo = JobGrpcClientUtils.waitFor(jobId, alluxioConf);
            if (jobInfo == null) break;
            if (jobInfo.getStatus() == Status.COMPLETED || jobInfo.getStatus() == Status.CANCELED) {
                return jobInfo.getId();
            }
            errorMessage = jobInfo.getErrorMessage();
            LOG.warn("Job {} failed to complete with attempt {}. error: {}", new Object[]{jobId, retryPolicy.getAttemptCount(), errorMessage});
        }
        throw new RuntimeException("Failed to successfully complete the job: " + errorMessage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static JobInfo waitFor(long jobId, AlluxioConfiguration alluxioConf) throws InterruptedException {
        try (JobMasterClient client = JobMasterClient.Factory.create(JobMasterClientContext.newBuilder(ClientContext.create((AlluxioConfiguration)alluxioConf)).build());){
            JobInfo jobInfo2 = (JobInfo)CommonUtils.waitForResult((String)"Job to finish", () -> {
                try {
                    return client.getJobStatus(jobId);
                }
                catch (Exception e) {
                    LOG.warn("Failed to get status for job (jobId={})", (Object)jobId, (Object)e);
                    return null;
                }
            }, jobInfo -> {
                if (jobInfo != null) {
                    switch (jobInfo.getStatus()) {
                        case FAILED: 
                        case CANCELED: 
                        case COMPLETED: {
                            return true;
                        }
                        case RUNNING: 
                        case CREATED: {
                            return false;
                        }
                    }
                    throw new IllegalStateException("Unrecognized job status: " + jobInfo.getStatus());
                }
                return true;
            }, (WaitForOptions)WaitForOptions.defaults().setInterval(1000));
            return jobInfo2;
        }
        catch (IOException e) {
            LOG.warn("Failed to close job master client: {}", (Object)e.toString());
            return null;
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    private JobGrpcClientUtils() {
    }
}

