/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.util;

import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SerializationUtils {
    private SerializationUtils() {
    }

    public static byte[] serialize(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        try (ByteArrayOutputStream b = new ByteArrayOutputStream();){
            try (ObjectOutputStream o = new ObjectOutputStream(b);){
                o.writeObject(obj);
            }
            byte[] byArray = b.toByteArray();
            return byArray;
        }
    }

    public static byte[] serialize(Object obj, String errorMessage) {
        try {
            return SerializationUtils.serialize(obj);
        }
        catch (IOException e) {
            throw new RuntimeException(errorMessage, e);
        }
    }

    /*
     * Exception decompiling
     */
    public static Serializable deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Serializable deserialize(byte[] bytes, String errorMessage) {
        try {
            return SerializationUtils.deserialize(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(errorMessage, e);
        }
    }

    public static <S, T extends Serializable> Map<S, ArrayList<T>> makeValuesSerializable(Map<S, Collection<T>> map) {
        return Maps.transformValues(map, ArrayList::new);
    }

    public static String parseBenchmarkResult(String result) {
        String[] taskResults = result.split("\n");
        boolean isActualResultStart = false;
        StringBuilder actualResult = new StringBuilder();
        for (String taskResult : taskResults) {
            if (isActualResultStart) {
                actualResult.append(taskResult);
                continue;
            }
            if (!taskResult.trim().equals("{")) continue;
            isActualResultStart = true;
            actualResult.append(taskResult);
        }
        return actualResult.toString();
    }
}

