/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format;

import alluxio.job.plan.transform.FieldSchema;
import alluxio.job.plan.transform.HiveConstants;
import alluxio.job.plan.transform.format.csv.CsvUtils;
import alluxio.job.plan.transform.format.csv.Decimal;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;

public class SchemaConversionUtils {
    private static final String JAVA_CLASS_FLAG = "java-class";

    public static Schema buildWriteSchema(List<FieldSchema> fields) throws IOException {
        SchemaBuilder.FieldAssembler<Schema> assembler = SchemaBuilder.record((String)Schema.Type.RECORD.getName()).fields();
        for (FieldSchema field : fields) {
            assembler = SchemaConversionUtils.buildWriteField(assembler, field);
        }
        return (Schema)assembler.endRecord();
    }

    private static Schema makeOptional(Schema schema) {
        return Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), schema));
    }

    public static SchemaBuilder.FieldAssembler<Schema> buildConsistentField(SchemaBuilder.FieldAssembler<Schema> assembler, FieldSchema field) throws IOException {
        String name = field.getName();
        String type = field.getType();
        switch (HiveConstants.Types.getHiveConstantType((String)type)) {
            case "boolean": {
                return assembler.optionalBoolean(name);
            }
            case "tinyint": 
            case "smallint": 
            case "int": {
                return assembler.optionalInt(name);
            }
            case "double": {
                return assembler.optionalDouble(name);
            }
            case "float": {
                return assembler.optionalFloat(name);
            }
            case "bigint": {
                return assembler.requiredLong(name);
            }
            case "string": 
            case "varchar": {
                return assembler.optionalString(name);
            }
            case "char": {
                Schema schema = (Schema)((SchemaBuilder.StringBldr)SchemaBuilder.builder().stringBuilder().prop(JAVA_CLASS_FLAG, Character.class.getCanonicalName())).endString();
                schema = SchemaConversionUtils.makeOptional(schema);
                return assembler.name(name).type(schema).noDefault();
            }
        }
        throw new IOException("Unsupported type " + type + " for field " + name);
    }

    private static SchemaBuilder.FieldAssembler<Schema> buildWriteField(SchemaBuilder.FieldAssembler<Schema> assembler, FieldSchema field) throws IOException {
        if (!CsvUtils.isReadWriteTypeInconsistent(field.getType())) {
            return SchemaConversionUtils.buildConsistentField(assembler, field);
        }
        String name = field.getName();
        String type = field.getType();
        switch (HiveConstants.Types.getHiveConstantType((String)type)) {
            case "decimal": {
                Decimal decimal = new Decimal(type);
                Schema schema = LogicalTypes.decimal((int)decimal.getPrecision(), (int)decimal.getScale()).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
                schema = SchemaConversionUtils.makeOptional(schema);
                return assembler.name(name).type(schema).noDefault();
            }
            case "binary": {
                return assembler.optionalBytes(name);
            }
            case "date": {
                Schema schema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
                schema = SchemaConversionUtils.makeOptional(schema);
                return assembler.name(name).type(schema).noDefault();
            }
            case "timestamp": {
                Schema schema = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
                schema = SchemaConversionUtils.makeOptional(schema);
                return assembler.name(name).type(schema).noDefault();
            }
        }
        throw new IOException("Unsupported type " + type + " for field " + name);
    }
}

