/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format;

import alluxio.AlluxioURI;
import alluxio.job.plan.transform.Format;
import alluxio.job.plan.transform.PartitionInfo;
import alluxio.job.plan.transform.format.ReadWriterUtils;
import alluxio.job.plan.transform.format.TableRow;
import alluxio.job.plan.transform.format.TableSchema;
import alluxio.job.plan.transform.format.csv.CsvReader;
import alluxio.job.plan.transform.format.orc.OrcReader;
import alluxio.job.plan.transform.format.parquet.ParquetReader;
import java.io.Closeable;
import java.io.IOException;

public interface TableReader
extends Closeable {
    public static TableReader create(AlluxioURI uri, PartitionInfo pInfo) throws IOException {
        ReadWriterUtils.checkUri(uri);
        Format format = pInfo.getFormat(uri.getName());
        switch (format) {
            case CSV: 
            case GZIP_CSV: {
                return CsvReader.create(uri, pInfo);
            }
            case PARQUET: {
                return ParquetReader.create(uri);
            }
            case ORC: {
                return OrcReader.create(uri);
            }
        }
        throw new IOException("Unsupported format: " + format);
    }

    public TableSchema getSchema() throws IOException;

    public TableRow read() throws IOException;

    @Override
    public void close() throws IOException;
}

