/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format.orc;

import alluxio.AlluxioURI;
import alluxio.job.plan.transform.format.JobPath;
import alluxio.job.plan.transform.format.ReadWriterUtils;
import alluxio.job.plan.transform.format.TableReader;
import alluxio.job.plan.transform.format.TableRow;
import alluxio.job.plan.transform.format.TableSchema;
import alluxio.job.plan.transform.format.orc.OrcRow;
import alluxio.job.plan.transform.format.orc.OrcSchema;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;

public final class OrcReader
implements TableReader {
    private final Closer mCloser = Closer.create();
    private final OrcSchema mSchema;
    private final Reader mReader;
    private final RecordReader mRows;
    private final List<String> mFieldNames;
    private VectorizedRowBatch mCurrentBatch;
    private int mCurrentBatchPosition;

    private OrcReader(JobPath inputPath) throws IOException {
        try {
            Configuration conf = ReadWriterUtils.readNoCacheConf();
            this.mReader = (Reader)this.mCloser.register((Closeable)OrcFile.createReader((Path)inputPath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf)));
            this.mFieldNames = this.mReader.getSchema().getFieldNames();
            this.mRows = this.mReader.rows();
            this.mSchema = new OrcSchema(this.mReader);
        }
        catch (IOException e) {
            try {
                this.mCloser.close();
            }
            catch (IOException ioe) {
                e.addSuppressed(ioe);
            }
            throw e;
        }
    }

    public static OrcReader create(AlluxioURI uri) throws IOException {
        JobPath path = new JobPath(uri.getScheme(), uri.getAuthority().toString(), uri.getPath());
        return new OrcReader(path);
    }

    @Override
    public TableSchema getSchema() {
        return this.mSchema;
    }

    @Override
    public TableRow read() throws IOException {
        if (this.mCurrentBatch == null || this.mCurrentBatch.size <= this.mCurrentBatchPosition) {
            this.mCurrentBatch = this.mReader.getSchema().createRowBatch();
            this.mCurrentBatchPosition = 0;
            if (!this.mRows.nextBatch(this.mCurrentBatch)) {
                return null;
            }
        }
        return new OrcRow(this.mSchema, this.mCurrentBatch, this.mCurrentBatchPosition++, this.mFieldNames);
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }
}

