/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.master.AlluxioJobMasterProcess;
import alluxio.master.PrimarySelector;
import alluxio.master.journal.JournalSystem;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class FaultTolerantAlluxioJobMasterProcess
extends AlluxioJobMasterProcess {
    private static final Logger LOG = LoggerFactory.getLogger(FaultTolerantAlluxioJobMasterProcess.class);
    private PrimarySelector mLeaderSelector;
    private Thread mServingThread;

    protected FaultTolerantAlluxioJobMasterProcess(JournalSystem journalSystem, PrimarySelector leaderSelector) {
        super(journalSystem);
        try {
            this.stopServing();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.mLeaderSelector = (PrimarySelector)Preconditions.checkNotNull((Object)leaderSelector, (Object)"leaderSelector");
        this.mServingThread = null;
    }

    @Override
    public void start() throws Exception {
        this.mJournalSystem.start();
        try {
            this.mLeaderSelector.start(this.getRpcAddress());
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        while (!Thread.interrupted()) {
            if (this.mServingThread == null) {
                this.mLeaderSelector.waitForState(PrimarySelector.State.PRIMARY);
                LOG.info("Transitioning from standby to primary");
                this.mJournalSystem.gainPrimacy();
                this.stopMaster();
                LOG.info("Secondary stopped");
                this.startMaster(true);
                this.mServingThread = new Thread(() -> this.startServing(" (gained leadership)", " (lost leadership)"), "MasterServingThread");
                this.mServingThread.start();
                LOG.info("Primary started");
                continue;
            }
            this.mLeaderSelector.waitForState(PrimarySelector.State.STANDBY);
            LOG.info("Transitioning from primary to standby");
            this.stopServing();
            this.mServingThread.join();
            this.mServingThread = null;
            this.stopMaster();
            this.mJournalSystem.losePrimacy();
            LOG.info("Primary stopped");
            this.startMaster(false);
            LOG.info("Standby started");
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        if (this.mLeaderSelector != null) {
            this.mLeaderSelector.stop();
        }
    }

    public boolean waitForGrpcServerReady(int timeoutMs) {
        try {
            CommonUtils.waitFor((String)((Object)((Object)this) + " to start"), () -> this.mServingThread == null || this.isGrpcServing(), (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(timeoutMs));
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (TimeoutException e) {
            return false;
        }
    }
}

