/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.ServerConfiguration;
import alluxio.exception.status.NotFoundException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.UfsInfo;
import alluxio.master.MasterClientContext;
import alluxio.master.file.FileSystemMasterClient;
import alluxio.resource.CloseableResource;
import alluxio.underfs.AbstractUfsManager;
import alluxio.underfs.UfsManager;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JobUfsManager
extends AbstractUfsManager {
    private static final Logger LOG = LoggerFactory.getLogger(JobUfsManager.class);
    private final FileSystemMasterClient mMasterClient;

    public JobUfsManager() {
        this.mMasterClient = (FileSystemMasterClient)((Object)this.mCloser.register((Closeable)((Object)new FileSystemMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)ServerConfiguration.global())).build()))));
    }

    protected void connectUfs(UnderFileSystem fs) throws IOException {
        fs.connectFromWorker(NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.JOB_WORKER_RPC, (AlluxioConfiguration)ServerConfiguration.global()));
    }

    public UfsManager.UfsClient get(long mountId) throws NotFoundException, UnavailableException {
        try {
            return super.get(mountId);
        }
        catch (NotFoundException notFoundException) {
            UfsInfo info;
            try {
                info = this.mMasterClient.getUfsInfo(mountId);
            }
            catch (IOException e) {
                throw new UnavailableException(String.format("Failed to create UFS info for mount point with id %d", mountId), (Throwable)e);
            }
            Preconditions.checkState((info.hasUri() && info.hasProperties() ? 1 : 0) != 0, (Object)"unknown mountId");
            super.addMount(mountId, new AlluxioURI(info.getUri()), UnderFileSystemConfiguration.defaults((AlluxioConfiguration)ServerConfiguration.global()).setReadOnly(info.getProperties().getReadOnly()).setShared(info.getProperties().getShared()).createMountSpecificConf(info.getProperties().getPropertiesMap()));
            UfsManager.UfsClient ufsClient = super.get(mountId);
            try (CloseableResource ufsResource = ufsClient.acquireUfsResource();){
                UnderFileSystem ufs = (UnderFileSystem)ufsResource.get();
                ufs.connectFromWorker(NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.WORKER_RPC, (AlluxioConfiguration)ServerConfiguration.global()));
            }
            catch (IOException e) {
                this.removeMount(mountId);
                throw new UnavailableException(String.format("Failed to connect to UFS %s with id %d", info.getUri(), mountId), (Throwable)e);
            }
            return ufsClient;
        }
    }
}

