/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format;

import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;

public class JobPath
extends Path {
    private static final long serialVersionUID = 1427341926575998813L;
    private static final ConcurrentHashMap<FileSystemKey, FileSystem> CACHE = new ConcurrentHashMap();

    @VisibleForTesting
    public static FileSystem fileSystemGet(URI uri, org.apache.hadoop.conf.Configuration conf) throws IOException {
        return FileSystem.get((URI)uri, (org.apache.hadoop.conf.Configuration)conf);
    }

    public JobPath(String scheme, String authority, String path) {
        super(scheme, authority, path);
    }

    public FileSystem getFileSystem(org.apache.hadoop.conf.Configuration conf) throws IOException {
        try {
            return CACHE.computeIfAbsent(new FileSystemKey(this, conf), key -> {
                try {
                    return JobPath.fileSystemGet(this.toUri(), conf);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    private static class FileSystemKey {
        final String mScheme;
        final String mAuthority;
        final UserGroupInformation mUgi;
        final ReadType mReadType;
        final WriteType mWriteType;

        public FileSystemKey(JobPath path, org.apache.hadoop.conf.Configuration conf) throws IOException {
            URI uri = path.toUri();
            this.mScheme = uri.getScheme() == null ? "" : uri.getScheme().toLowerCase();
            this.mAuthority = uri.getAuthority() == null ? "" : uri.getAuthority().toLowerCase();
            this.mUgi = UserGroupInformation.getCurrentUser();
            this.mReadType = (ReadType)conf.getEnum(PropertyKey.USER_FILE_READ_TYPE_DEFAULT.getName(), Configuration.getEnum((PropertyKey)PropertyKey.USER_FILE_READ_TYPE_DEFAULT, ReadType.class));
            this.mWriteType = (WriteType)conf.getEnum(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT.getName(), Configuration.getEnum((PropertyKey)PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.class));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mScheme, this.mAuthority, this.mUgi, this.mReadType, this.mWriteType});
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileSystemKey)) {
                return false;
            }
            FileSystemKey that = (FileSystemKey)o;
            return Objects.equal((Object)this.mScheme, (Object)that.mScheme) && Objects.equal((Object)this.mAuthority, (Object)that.mAuthority) && Objects.equal((Object)this.mUgi, (Object)that.mUgi) && Objects.equal((Object)this.mReadType, (Object)that.mReadType) && Objects.equal((Object)this.mWriteType, (Object)that.mWriteType);
        }
    }
}

