/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format.csv;

import alluxio.job.plan.transform.FieldSchema;
import alluxio.job.plan.transform.format.SchemaConversionUtils;
import alluxio.job.plan.transform.format.TableSchema;
import alluxio.job.plan.transform.format.csv.CsvUtils;
import alluxio.job.plan.transform.format.parquet.ParquetSchema;
import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import javax.validation.constraints.NotNull;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;

public final class CsvSchema
implements TableSchema {
    private final ArrayList<FieldSchema> mAlluxioSchema;
    private final Schema mReadSchema;
    private final Schema mWriteSchema;

    public CsvSchema(@NotNull ArrayList<FieldSchema> schema) throws IOException {
        this.mAlluxioSchema = schema;
        this.mReadSchema = this.buildReadSchema(Schema.Type.RECORD.getName(), schema);
        this.mWriteSchema = SchemaConversionUtils.buildWriteSchema(schema);
    }

    public ArrayList<FieldSchema> getAlluxioSchema() {
        return this.mAlluxioSchema;
    }

    public Schema getReadSchema() {
        return this.mReadSchema;
    }

    public Schema getWriteSchema() {
        return this.mWriteSchema;
    }

    @Override
    public ParquetSchema toParquet() {
        return new ParquetSchema(this.mWriteSchema);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mAlluxioSchema, this.mReadSchema, this.mWriteSchema});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CsvSchema)) {
            return false;
        }
        CsvSchema that = (CsvSchema)o;
        return Objects.equal(this.mAlluxioSchema, that.mAlluxioSchema) && Objects.equal((Object)this.mReadSchema, (Object)that.mReadSchema) && Objects.equal((Object)this.mWriteSchema, (Object)that.mWriteSchema);
    }

    private Schema buildReadSchema(String name, ArrayList<FieldSchema> fields) throws IOException {
        SchemaBuilder.FieldAssembler<Schema> assembler = SchemaBuilder.record((String)name).fields();
        for (FieldSchema field : fields) {
            assembler = this.buildReadField(assembler, field);
        }
        return (Schema)assembler.endRecord();
    }

    private SchemaBuilder.FieldAssembler<Schema> buildReadField(SchemaBuilder.FieldAssembler<Schema> assembler, FieldSchema field) throws IOException {
        if (!CsvUtils.isReadWriteTypeInconsistent(field.getType())) {
            return SchemaConversionUtils.buildConsistentField(assembler, field);
        }
        String name = field.getName();
        return assembler.optionalString(name);
    }
}

