/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format.orc;

import alluxio.job.plan.transform.FieldSchema;
import alluxio.job.plan.transform.format.SchemaConversionUtils;
import alluxio.job.plan.transform.format.TableSchema;
import alluxio.job.plan.transform.format.parquet.ParquetSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;

public class OrcSchema
implements TableSchema {
    private final ArrayList<FieldSchema> mAlluxioSchema;
    private final Schema mWriteSchema;

    public OrcSchema(Reader reader) throws IOException {
        List fieldNames = reader.getSchema().getFieldNames();
        this.mAlluxioSchema = new ArrayList(fieldNames.size());
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldName = (String)fieldNames.get(i);
            String type = this.getType((TypeDescription)reader.getSchema().getChildren().get(i));
            this.mAlluxioSchema.add(new FieldSchema(i, fieldName, type, ""));
        }
        this.mWriteSchema = SchemaConversionUtils.buildWriteSchema(this.mAlluxioSchema);
    }

    private String getType(TypeDescription typeDescription) {
        TypeDescription.Category category = typeDescription.getCategory();
        switch (category) {
            case DECIMAL: {
                return String.format("decimal(%d,%d)", typeDescription.getPrecision(), typeDescription.getScale());
            }
            case CHAR: 
            case VARCHAR: {
                return String.format("%s(%d)", category.getName(), typeDescription.getMaxLength());
            }
        }
        return category.getName();
    }

    @Override
    public ParquetSchema toParquet() {
        return new ParquetSchema(this.mWriteSchema);
    }

    public ArrayList<FieldSchema> getAlluxioSchema() {
        return this.mAlluxioSchema;
    }

    public Schema getWriteSchema() {
        return this.mWriteSchema;
    }
}

