/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format.parquet;

import alluxio.AlluxioURI;
import alluxio.job.plan.transform.format.JobPath;
import alluxio.job.plan.transform.format.ReadWriterUtils;
import alluxio.job.plan.transform.format.TableReader;
import alluxio.job.plan.transform.format.TableRow;
import alluxio.job.plan.transform.format.TableSchema;
import alluxio.job.plan.transform.format.parquet.ParquetRow;
import alluxio.job.plan.transform.format.parquet.ParquetSchema;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;

public final class ParquetReader
implements TableReader {
    private final org.apache.parquet.hadoop.ParquetReader<GenericData.Record> mReader;
    private final ParquetSchema mSchema;
    private final ParquetMetadata mMetadata;

    private ParquetReader(org.apache.parquet.hadoop.ParquetReader<GenericData.Record> reader, Schema schema, ParquetMetadata metadata) {
        this.mReader = reader;
        this.mSchema = new ParquetSchema(schema);
        this.mMetadata = metadata;
    }

    public static ParquetReader create(AlluxioURI uri) throws IOException {
        Schema schema;
        ParquetMetadata footer;
        JobPath inputPath = new JobPath(uri.getScheme(), uri.getAuthority().toString(), uri.getPath());
        Configuration conf = ReadWriterUtils.readNoCacheConf();
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)inputPath, (Configuration)conf);
        org.apache.parquet.hadoop.ParquetReader reader = AvroParquetReader.builder((InputFile)inputFile).disableCompatibility().withDataModel(GenericData.get()).withConf(conf).build();
        try (ParquetFileReader r = new ParquetFileReader((InputFile)inputFile, ParquetReadOptions.builder().build());){
            footer = r.getFooter();
            schema = new AvroSchemaConverter().convert(footer.getFileMetaData().getSchema());
        }
        return new ParquetReader((org.apache.parquet.hadoop.ParquetReader<GenericData.Record>)reader, schema, footer);
    }

    @Override
    public TableSchema getSchema() throws IOException {
        return this.mSchema;
    }

    public ParquetMetadata getMetadata() {
        return this.mMetadata;
    }

    @Override
    public TableRow read() throws IOException {
        GenericData.Record record = (GenericData.Record)this.mReader.read();
        return record == null ? null : new ParquetRow(record);
    }

    @Override
    public void close() throws IOException {
        this.mReader.close();
    }
}

