/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format.tables;

import alluxio.AlluxioURI;
import alluxio.job.plan.transform.format.TableRow;
import alluxio.job.plan.transform.format.TableSchema;
import alluxio.job.plan.transform.format.TableWriter;
import alluxio.job.plan.transform.format.tables.Committer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablesWriter
implements TableWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TablesWriter.class);
    private static final String FILE_NAME_PATTERN = "part-%d.parquet";
    private final Committer mCommitter;
    private final TableSchema mSchema;
    private final AlluxioURI mOutputDir;
    private TableWriter mWriter;
    private int mPart;
    private int mRows;
    private int mBytes;

    private TablesWriter(TableSchema schema, Committer committer, AlluxioURI outputDir, TableWriter initialWriter) {
        this.mOutputDir = outputDir;
        this.mSchema = schema;
        this.mWriter = initialWriter;
        this.mCommitter = committer;
        this.mPart = 0;
        this.mRows = 0;
        this.mBytes = 0;
    }

    public static TablesWriter create(TableSchema schema, Committer committer, AlluxioURI outputDir) throws IOException {
        return new TablesWriter(schema, committer, outputDir, TablesWriter.createWriter(schema, outputDir, 0));
    }

    @Override
    public void write(TableRow row) throws IOException {
        this.mWriter.write(row);
        if (this.mCommitter.shouldCommit(this.mWriter)) {
            this.mRows += this.mWriter.getRows();
            this.mBytes = (int)((long)this.mBytes + this.mWriter.getBytes());
            this.mWriter.close();
            this.mWriter = TablesWriter.createWriter(this.mSchema, this.mOutputDir, ++this.mPart);
        }
    }

    @Override
    public void close() throws IOException {
        this.mWriter.close();
    }

    @Override
    public int getRows() {
        return this.mRows + this.mWriter.getRows();
    }

    @Override
    public long getBytes() {
        return (long)this.mBytes + this.mWriter.getBytes();
    }

    private static TableWriter createWriter(TableSchema schema, AlluxioURI outputDir, int part) throws IOException {
        String filename = String.format(FILE_NAME_PATTERN, part);
        return TableWriter.create(schema, outputDir.join(filename));
    }
}

