/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Process;
import alluxio.ProcessUtils;
import alluxio.master.AlluxioJobMasterProcess;
import alluxio.util.CommonUtils;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class AlluxioJobMaster {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioJobMaster.class);

    public static void main(String[] args) {
        AlluxioJobMasterProcess process;
        if (args.length != 0) {
            LOG.info("java -cp {} {}", (Object)"target/alluxio-2.9.0-jar-with-dependencies.jar", (Object)AlluxioJobMaster.class.getCanonicalName());
            System.exit(-1);
        }
        CommonUtils.PROCESS_TYPE.set(CommonUtils.ProcessType.JOB_MASTER);
        try {
            process = AlluxioJobMasterProcess.Factory.create();
        }
        catch (Throwable t) {
            LOG.error("Failed to create job master process", t);
            System.exit(-1);
            throw t;
        }
        ProcessUtils.stopProcessOnShutdown((Process)process);
        ProcessUtils.run((Process)process);
    }

    private AlluxioJobMaster() {
    }
}

