/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job;

import alluxio.master.audit.AsyncUserAccessAuditLogWriter;
import alluxio.master.audit.AuditContext;
import alluxio.security.authentication.AuthType;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JobMasterAuditContext
implements AuditContext {
    private final AsyncUserAccessAuditLogWriter mAsyncAuditLogWriter;
    private boolean mAllowed;
    private boolean mSucceeded;
    private String mCommand;
    private String mUgi;
    private AuthType mAuthType;
    private String mIp;
    private long mJobId;
    private String mJobName;
    private long mCreationTimeNs;
    private long mExecutionTimeNs;

    public JobMasterAuditContext setAllowed(boolean allowed) {
        this.mAllowed = allowed;
        return this;
    }

    public JobMasterAuditContext setSucceeded(boolean succeeded) {
        this.mSucceeded = succeeded;
        return this;
    }

    public JobMasterAuditContext setCommand(String command) {
        this.mCommand = command;
        return this;
    }

    public JobMasterAuditContext setUgi(String ugi) {
        this.mUgi = ugi;
        return this;
    }

    public JobMasterAuditContext setAuthType(AuthType authType) {
        this.mAuthType = authType;
        return this;
    }

    public JobMasterAuditContext setIp(String ip) {
        this.mIp = ip;
        return this;
    }

    public JobMasterAuditContext setCreationTimeNs(long creationTimeNs) {
        this.mCreationTimeNs = creationTimeNs;
        return this;
    }

    public JobMasterAuditContext setJobId(long jobId) {
        this.mJobId = jobId;
        return this;
    }

    public JobMasterAuditContext setJobName(String jobName) {
        this.mJobName = jobName;
        return this;
    }

    protected JobMasterAuditContext(AsyncUserAccessAuditLogWriter asyncAuditLogWriter) {
        this.mAsyncAuditLogWriter = asyncAuditLogWriter;
        this.mAllowed = true;
    }

    public void close() {
        if (this.mAsyncAuditLogWriter == null) {
            return;
        }
        this.mExecutionTimeNs = System.nanoTime() - this.mCreationTimeNs;
        this.mAsyncAuditLogWriter.append((AuditContext)this);
    }

    public String toString() {
        return String.format("succeeded=%b\tallowed=%b\tugi=%s (AUTH=%s)\tip=%s\tcmd=%s\tmJobId=%d\tmJobName=%s\tperm=null\texecutionTimeUs=%d", this.mSucceeded, this.mAllowed, this.mUgi, this.mAuthType, this.mIp, this.mCommand, this.mJobId, this.mJobName, this.mExecutionTimeNs / 1000L);
    }
}

