/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.tracker;

import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.job.wire.Status;
import alluxio.master.job.JobMaster;
import alluxio.master.job.tracker.CmdRunAttempt;
import alluxio.util.CommonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCmdRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCmdRunner.class);
    protected static final int DEFAULT_ACTIVE_JOBS = 3000;
    protected static final long DEFAULT_FILE_COUNT = 1L;
    protected FileSystem mFileSystem;
    protected FileSystemContext mFsContext;
    protected List<CmdRunAttempt> mSubmitted = Lists.newArrayList();
    protected Map<Long, List<CmdRunAttempt>> mJobMap = Maps.newHashMap();
    protected int mActiveJobs = 3000;
    protected final JobMaster mJobMaster;
    private int mFailedCount = 0;
    private int mCompletedCount = 0;

    protected AbstractCmdRunner(@Nullable FileSystemContext fsContext, JobMaster jobMaster) {
        if (fsContext == null) {
            fsContext = FileSystemContext.create();
        }
        this.mFsContext = fsContext;
        this.mFileSystem = FileSystem.Factory.create((FileSystemContext)fsContext);
        this.mJobMaster = jobMaster;
    }

    protected void waitForCmdJob() {
        AtomicBoolean removed = new AtomicBoolean(false);
        while (true) {
            this.mSubmitted = this.mSubmitted.stream().filter(attempt -> {
                Status check = attempt.checkJobStatus();
                switch (check) {
                    case CREATED: 
                    case RUNNING: {
                        return true;
                    }
                    case CANCELED: 
                    case COMPLETED: {
                        ++this.mCompletedCount;
                        removed.set(true);
                        return false;
                    }
                    case FAILED: {
                        ++this.mFailedCount;
                        removed.set(true);
                        return false;
                    }
                }
                throw new IllegalStateException(String.format("Unexpected Status: %s", check));
            }).collect(Collectors.toList());
            if (removed.get()) {
                return;
            }
            CommonUtils.sleepMs((long)5L);
        }
    }
}

