/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.tracker;

import alluxio.AlluxioURI;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.InvalidPathException;
import alluxio.grpc.OperationType;
import alluxio.job.JobConfig;
import alluxio.job.plan.BatchedJobConfig;
import alluxio.job.plan.migrate.MigrateConfig;
import alluxio.job.wire.JobSource;
import alluxio.master.job.JobMaster;
import alluxio.master.job.common.CmdInfo;
import alluxio.master.job.metrics.DistributedCmdMetrics;
import alluxio.master.job.tracker.AbstractCmdRunner;
import alluxio.master.job.tracker.CmdRunAttempt;
import alluxio.retry.CountingRetry;
import alluxio.retry.RetryPolicy;
import alluxio.util.io.PathUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateCliRunner
extends AbstractCmdRunner {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateCliRunner.class);

    public MigrateCliRunner(FileSystemContext fsContext, JobMaster jobMaster) {
        super(fsContext, jobMaster);
    }

    public CmdInfo runDistCp(AlluxioURI srcPath, AlluxioURI dstPath, boolean overwrite, int batchSize, long jobControlId) throws IOException {
        long submissionTime = System.currentTimeMillis();
        AlluxioConfiguration conf = this.mFsContext.getPathConf(dstPath);
        WriteType writeType = (WriteType)conf.getEnum(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.class);
        ArrayList<Pair<String, String>> filePool = new ArrayList<Pair<String, String>>(batchSize);
        ArrayList filePath = Lists.newArrayList((Object[])new String[]{srcPath.getPath()});
        CmdInfo cmdInfo = new CmdInfo(jobControlId, OperationType.DIST_CP, JobSource.CLI, submissionTime, filePath);
        try {
            if (this.mFileSystem.getStatus(srcPath).isFolder()) {
                this.createFolders(srcPath, dstPath, this.mFileSystem);
            }
            this.copy(srcPath, dstPath, overwrite, batchSize, filePool, writeType, cmdInfo);
        }
        catch (AlluxioException | IOException e) {
            LOG.warn("failing in distcp!");
            LOG.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        if (filePool.size() > 0) {
            this.submitDistCp(filePool, overwrite, writeType, cmdInfo);
            filePool.clear();
        }
        return cmdInfo;
    }

    private void copy(AlluxioURI srcPath, AlluxioURI dstPath, boolean overwrite, int batchSize, List<Pair<String, String>> pool, WriteType writeType, CmdInfo cmdInfo) throws IOException, AlluxioException {
        for (URIStatus srcInnerStatus : this.mFileSystem.listStatus(srcPath)) {
            String dstInnerPath = this.computeTargetPath(srcInnerStatus.getPath(), srcPath.getPath(), dstPath.getPath());
            if (srcInnerStatus.isFolder()) {
                this.copy(new AlluxioURI(srcInnerStatus.getPath()), new AlluxioURI(dstInnerPath), overwrite, batchSize, pool, writeType, cmdInfo);
                continue;
            }
            pool.add((Pair<String, String>)new Pair((Object)srcInnerStatus.getPath(), (Object)dstInnerPath));
            if (pool.size() != batchSize) continue;
            this.submitDistCp(pool, overwrite, writeType, cmdInfo);
            pool.clear();
        }
    }

    private void submitDistCp(List<Pair<String, String>> pool, boolean overwrite, WriteType writeType, CmdInfo cmdInfo) {
        if (this.mSubmitted.size() >= 3000) {
            this.waitForCmdJob();
        }
        CmdRunAttempt attempt = new CmdRunAttempt((RetryPolicy)new CountingRetry(3), this.mJobMaster);
        this.setJobConfigAndFileMetrics(pool, overwrite, writeType, attempt);
        this.mSubmitted.add(attempt);
        cmdInfo.addCmdRunAttempt(attempt);
        attempt.run();
    }

    public void setJobConfigAndFileMetrics(List<Pair<String, String>> filePath, boolean overwrite, WriteType writeType, CmdRunAttempt attempt) {
        MigrateConfig jobConfig;
        int poolSize = filePath.size();
        long fileCount = 0L;
        long fileSize = 0L;
        String filePathString = filePath.stream().map(Pair::getFirst).collect(Collectors.joining(","));
        if (poolSize == 1) {
            Pair<String, String> pair = filePath.iterator().next();
            String source = (String)pair.getFirst();
            jobConfig = new MigrateConfig(source, (String)pair.getSecond(), writeType, overwrite);
            fileCount = 1L;
            fileSize = DistributedCmdMetrics.getFileSize(source, this.mFileSystem, (RetryPolicy)new CountingRetry(3));
        } else {
            HashSet configs = Sets.newHashSet();
            ObjectMapper oMapper = new ObjectMapper();
            for (Pair<String, String> pair : filePath) {
                String source = (String)pair.getFirst();
                MigrateConfig config = new MigrateConfig(source, (String)pair.getSecond(), writeType, overwrite);
                Map map = (Map)oMapper.convertValue((Object)config, Map.class);
                configs.add(map);
                fileSize += DistributedCmdMetrics.getFileSize(source, this.mFileSystem, (RetryPolicy)new CountingRetry(3));
            }
            fileCount = poolSize;
            jobConfig = new BatchedJobConfig("Migrate", (Set)configs);
        }
        attempt.setFileCount(fileCount);
        attempt.setFileSize(fileSize);
        attempt.setConfig((JobConfig)jobConfig);
        attempt.setFilePath(filePathString);
    }

    private void createFolders(AlluxioURI srcPath, AlluxioURI dstPath, FileSystem fileSystem) throws IOException, AlluxioException {
        block3: {
            try {
                fileSystem.createDirectory(dstPath);
                System.out.println("Created directory at " + dstPath.getPath());
            }
            catch (FileAlreadyExistsException e) {
                if (fileSystem.getStatus(dstPath).isFolder()) break block3;
                throw e;
            }
        }
        for (URIStatus srcInnerStatus : fileSystem.listStatus(srcPath)) {
            if (!srcInnerStatus.isFolder()) continue;
            String dstInnerPath = this.computeTargetPath(srcInnerStatus.getPath(), srcPath.getPath(), dstPath.getPath());
            this.createFolders(new AlluxioURI(srcInnerStatus.getPath()), new AlluxioURI(dstInnerPath), fileSystem);
        }
    }

    private String computeTargetPath(String path, String source, String destination) throws InvalidPathException {
        String relativePath = PathUtils.subtractPaths((String)path, (String)source);
        return PathUtils.concatPath((Object)destination, (Object)relativePath);
    }
}

