/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.master.AlluxioJobMasterProcess;
import alluxio.util.io.PathUtils;
import alluxio.web.WebServer;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

@NotThreadSafe
public final class JobMasterWebServer
extends WebServer {
    public static final String ALLUXIO_JOB_MASTER_SERVLET_RESOURCE_KEY = "Alluxio Job Master";

    public JobMasterWebServer(String serviceName, InetSocketAddress address, final AlluxioJobMasterProcess jobMaster) {
        super(serviceName, address);
        ResourceConfig config = new ResourceConfig().packages(new String[]{"alluxio.master", "alluxio.master.job"});
        ServletContainer servlet = new ServletContainer(config){
            private static final long serialVersionUID = 7756010860672831556L;

            public void init() throws ServletException {
                super.init();
                this.getServletContext().setAttribute(JobMasterWebServer.ALLUXIO_JOB_MASTER_SERVLET_RESOURCE_KEY, (Object)jobMaster);
            }
        };
        ServletHolder servletHolder = new ServletHolder("Alluxio Job Master Web Service", (Servlet)servlet);
        this.mServletContextHandler.addServlet(servletHolder, PathUtils.concatPath((Object)"/api/v1", (Object)"*"));
    }
}

