/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.job;

import alluxio.AbstractJobMasterClient;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.JobCommand;
import alluxio.grpc.JobHeartbeatPRequest;
import alluxio.grpc.JobInfo;
import alluxio.grpc.JobMasterWorkerServiceGrpc;
import alluxio.grpc.RegisterJobWorkerPRequest;
import alluxio.grpc.ServiceType;
import alluxio.job.wire.JobWorkerHealth;
import alluxio.master.MasterClientContext;
import alluxio.util.CommonUtils;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.job.JobMasterClient;
import alluxio.worker.job.JobMasterClientContext;
import io.grpc.Channel;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class RetryHandlingJobMasterClient
extends AbstractJobMasterClient
implements JobMasterClient {
    private static final Logger RPC_LOG = LoggerFactory.getLogger(JobMasterClient.class);
    private JobMasterWorkerServiceGrpc.JobMasterWorkerServiceBlockingStub mClient = null;

    public RetryHandlingJobMasterClient(JobMasterClientContext conf) {
        super((MasterClientContext)conf);
    }

    protected ServiceType getRemoteServiceType() {
        return ServiceType.JOB_MASTER_WORKER_SERVICE;
    }

    protected String getServiceName() {
        return "JobMasterWorker";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    protected void afterConnect() {
        this.mClient = JobMasterWorkerServiceGrpc.newBlockingStub((Channel)this.mChannel);
    }

    @Override
    public long registerWorker(WorkerNetAddress address) throws IOException {
        return (Long)this.retryRPC(() -> this.mClient.registerJobWorker(RegisterJobWorkerPRequest.newBuilder().setWorkerNetAddress(GrpcUtils.toProto((WorkerNetAddress)address)).build()).getId(), RPC_LOG, "RegisterWorker", "address=%s", new Object[]{address});
    }

    @Override
    public List<JobCommand> heartbeat(JobWorkerHealth jobWorkerHealth, List<JobInfo> taskInfoList) throws IOException {
        return (List)this.retryRPC(() -> this.mClient.heartbeat(JobHeartbeatPRequest.newBuilder().setJobWorkerHealth(jobWorkerHealth.toProto()).addAllTaskInfos((Iterable)taskInfoList).build()).getCommandsList(), RPC_LOG, "Heartbeat", "jobWorkerHealth=%s,taskInfoList=%s", new Object[]{jobWorkerHealth, CommonUtils.summarizeCollection(taskInfoList)});
    }
}

