/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.command;

import alluxio.AlluxioMockUtil;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.grpc.JobCommand;
import alluxio.grpc.RunTaskCommand;
import alluxio.job.JobServerContext;
import alluxio.job.RunTaskContext;
import alluxio.job.TestPlanConfig;
import alluxio.job.util.SerializationUtils;
import alluxio.job.wire.JobWorkerHealth;
import alluxio.underfs.UfsManager;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.job.JobMasterClient;
import alluxio.worker.job.command.CommandHandlingExecutor;
import alluxio.worker.job.task.TaskExecutorManager;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class CommandHandlingExecutorTest {
    private CommandHandlingExecutor mCommandHandlingExecutor;
    private JobMasterClient mJobMasterClient;
    private TaskExecutorManager mTaskExecutorManager;
    private UfsManager mUfsManager;
    private FileSystemContext mFileSystemContext;
    private FileSystem mFileSystem;

    @Before
    public void before() {
        this.mJobMasterClient = (JobMasterClient)Mockito.mock(JobMasterClient.class);
        this.mTaskExecutorManager = (TaskExecutorManager)Mockito.mock(TaskExecutorManager.class);
        WorkerNetAddress workerNetAddress = (WorkerNetAddress)Mockito.mock(WorkerNetAddress.class);
        this.mUfsManager = (UfsManager)Mockito.mock(UfsManager.class);
        this.mFileSystemContext = (FileSystemContext)Mockito.mock(FileSystemContext.class);
        this.mFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        JobServerContext ctx = new JobServerContext(this.mFileSystem, this.mFileSystemContext, this.mUfsManager);
        this.mCommandHandlingExecutor = new CommandHandlingExecutor(ctx, this.mTaskExecutorManager, this.mJobMasterClient, workerNetAddress);
    }

    @Test
    public void heartbeat() throws Exception {
        JobCommand.Builder command = JobCommand.newBuilder();
        RunTaskCommand.Builder runTaskCommand = RunTaskCommand.newBuilder();
        long jobId = 1L;
        runTaskCommand.setJobId(jobId);
        long taskId = 2L;
        runTaskCommand.setTaskId(taskId);
        TestPlanConfig jobConfig = new TestPlanConfig("/test");
        runTaskCommand.setJobConfig(ByteString.copyFrom((byte[])SerializationUtils.serialize((Object)jobConfig)));
        ArrayList taskArgs = Lists.newArrayList((Object[])new Integer[]{1});
        runTaskCommand.setTaskArgs(ByteString.copyFrom((byte[])SerializationUtils.serialize((Object)taskArgs)));
        command.setRunTaskCommand(runTaskCommand);
        Mockito.when((Object)this.mJobMasterClient.heartbeat((JobWorkerHealth)Mockito.any(JobWorkerHealth.class), (List)Mockito.eq((Object)Lists.newArrayList()))).thenReturn((Object)Lists.newArrayList((Object[])new JobCommand[]{command.build()}));
        this.mCommandHandlingExecutor.heartbeat();
        ExecutorService executorService = (ExecutorService)AlluxioMockUtil.getInternalState((Object)this.mCommandHandlingExecutor, (String)"mCommandHandlingService");
        executorService.shutdown();
        Assert.assertTrue((boolean)executorService.awaitTermination(5000L, TimeUnit.MILLISECONDS));
        ((TaskExecutorManager)Mockito.verify((Object)this.mTaskExecutorManager)).getAndClearTaskUpdates();
        ((TaskExecutorManager)Mockito.verify((Object)this.mTaskExecutorManager)).executeTask(Mockito.eq((long)jobId), Mockito.eq((long)taskId), (RunTaskCommand)Mockito.eq((Object)runTaskCommand.build()), (RunTaskContext)Mockito.any(RunTaskContext.class));
    }
}

