/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.block.BlockStoreClient;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.job.JobServerContext;
import alluxio.job.SelectExecutorsContext;
import alluxio.job.plan.BatchedJobConfig;
import alluxio.job.plan.batch.BatchedJobDefinition;
import alluxio.job.plan.load.LoadConfig;
import alluxio.job.plan.persist.PersistConfig;
import alluxio.underfs.UfsManager;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.FileInfo;
import alluxio.wire.TieredIdentity;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class BatchedJobDefinitionTest {
    private static final String TEST_URI = "/test";
    private static final WorkerNetAddress WORKER_ADDR_0 = new WorkerNetAddress().setHost("host0").setTieredIdentity(new TieredIdentity(Collections.singletonList(new TieredIdentity.LocalityTier("rack", "rack1"))));
    private static final WorkerNetAddress WORKER_ADDR_1 = new WorkerNetAddress().setHost("host1").setTieredIdentity(new TieredIdentity(Collections.singletonList(new TieredIdentity.LocalityTier("rack", "rack1"))));
    private static final WorkerNetAddress WORKER_ADDR_2 = new WorkerNetAddress().setHost("host2").setTieredIdentity(new TieredIdentity(Collections.singletonList(new TieredIdentity.LocalityTier("rack", "rack2"))));
    private static final WorkerNetAddress WORKER_ADDR_3 = new WorkerNetAddress().setHost("host3").setTieredIdentity(new TieredIdentity(Collections.singletonList(new TieredIdentity.LocalityTier("rack", "rack2"))));
    private static final List<WorkerInfo> JOB_WORKERS = new ImmutableList.Builder().add((Object)new WorkerInfo().setId(0L).setAddress(WORKER_ADDR_0)).add((Object)new WorkerInfo().setId(1L).setAddress(WORKER_ADDR_1)).add((Object)new WorkerInfo().setId(2L).setAddress(WORKER_ADDR_2)).add((Object)new WorkerInfo().setId(3L).setAddress(WORKER_ADDR_3)).build();
    private static final List<BlockWorkerInfo> BLOCK_WORKERS = new ImmutableList.Builder().add((Object)new BlockWorkerInfo(WORKER_ADDR_0, 0L, 0L)).add((Object)new BlockWorkerInfo(WORKER_ADDR_1, 0L, 0L)).add((Object)new BlockWorkerInfo(WORKER_ADDR_2, 0L, 0L)).add((Object)new BlockWorkerInfo(WORKER_ADDR_3, 0L, 0L)).build();
    private JobServerContext mJobServerContext;
    private FileSystem mMockFileSystem;
    private BlockStoreClient mMockBlockStore;
    private FileSystemContext mMockFsContext;

    @Before
    public void before() throws Exception {
        this.mMockFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        this.mMockFsContext = (FileSystemContext)Mockito.mock(FileSystemContext.class);
        Mockito.when((Object)this.mMockFsContext.getCachedWorkers()).thenReturn(BLOCK_WORKERS);
        Mockito.when((Object)this.mMockFsContext.getClientContext()).thenReturn((Object)ClientContext.create((AlluxioConfiguration)Configuration.global()));
        Mockito.when((Object)this.mMockFsContext.getClusterConf()).thenReturn((Object)Configuration.global());
        Mockito.when((Object)this.mMockFsContext.getPathConf((AlluxioURI)ArgumentMatchers.any(AlluxioURI.class))).thenReturn((Object)Configuration.global());
        this.mJobServerContext = new JobServerContext(this.mMockFileSystem, this.mMockFsContext, (UfsManager)Mockito.mock(UfsManager.class));
    }

    @Test
    public void batchLoad() throws Exception {
        int numBlocks = 2;
        int replication = 2;
        int batchSize = 2;
        HashSet configs = Sets.newHashSet();
        for (int i = 0; i < batchSize; ++i) {
            this.createFileWithNoLocations(TEST_URI + i, numBlocks);
            LoadConfig loadConfig = new LoadConfig(TEST_URI + i, Integer.valueOf(replication), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Boolean.valueOf(true));
            ObjectMapper oMapper = new ObjectMapper();
            Map map = (Map)oMapper.convertValue((Object)loadConfig, Map.class);
            configs.add(map);
        }
        BatchedJobConfig config = new BatchedJobConfig("Load", (Set)configs);
        Set assignments = new BatchedJobDefinition().selectExecutors(config, JOB_WORKERS, new SelectExecutorsContext(1L, this.mJobServerContext));
        int totalBlockLoads = 0;
        for (Pair assignment : assignments) {
            ArrayList second = (ArrayList)((BatchedJobDefinition.BatchedJobTask)assignment.getSecond()).getJobTaskArgs();
            totalBlockLoads += second.size();
        }
        Assert.assertEquals((long)(numBlocks * replication * batchSize), (long)totalBlockLoads);
    }

    private FileInfo createFileWithNoLocations(String testFile, int numOfBlocks) throws Exception {
        FileInfo testFileInfo = new FileInfo();
        AlluxioURI uri = new AlluxioURI(testFile);
        ArrayList blockInfos = Lists.newArrayList();
        for (int i = 0; i < numOfBlocks; ++i) {
            blockInfos.add(new FileBlockInfo().setBlockInfo(new BlockInfo().setLocations((List)Lists.newArrayList())));
        }
        testFileInfo.setFolder(false).setPath(testFile).setFileBlockInfos((List)blockInfos);
        Mockito.when((Object)this.mMockFileSystem.listStatus(uri)).thenReturn((Object)Lists.newArrayList((Object[])new URIStatus[]{new URIStatus(testFileInfo)}));
        Mockito.when((Object)this.mMockFileSystem.getStatus(uri)).thenReturn((Object)new URIStatus(testFileInfo));
        return testFileInfo;
    }

    @Test
    public void batchPersist() throws Exception {
        AlluxioURI uri = new AlluxioURI(TEST_URI);
        PersistConfig config = new PersistConfig(uri.getPath(), -1L, true, "");
        HashSet configs = Sets.newHashSet();
        ObjectMapper oMapper = new ObjectMapper();
        Map map = (Map)oMapper.convertValue((Object)config, Map.class);
        configs.add(map);
        BatchedJobConfig batchedJobConfig = new BatchedJobConfig("Persist", (Set)configs);
        WorkerNetAddress workerNetAddress = new WorkerNetAddress().setDataPort(10);
        WorkerInfo workerInfo = new WorkerInfo().setAddress(workerNetAddress);
        long blockId = 1L;
        BlockInfo blockInfo = new BlockInfo().setBlockId(blockId);
        FileBlockInfo fileBlockInfo = new FileBlockInfo().setBlockInfo(blockInfo);
        BlockLocation location = new BlockLocation();
        location.setWorkerAddress(workerNetAddress);
        blockInfo.setLocations((List)Lists.newArrayList((Object[])new BlockLocation[]{location}));
        FileInfo testFileInfo = new FileInfo();
        testFileInfo.setFileBlockInfos((List)Lists.newArrayList((Object[])new FileBlockInfo[]{fileBlockInfo}));
        Mockito.when((Object)this.mMockFileSystem.getStatus(uri)).thenReturn((Object)new URIStatus(testFileInfo));
        Set result = new BatchedJobDefinition().selectExecutors(batchedJobConfig, (List)Lists.newArrayList((Object[])new WorkerInfo[]{workerInfo}), new SelectExecutorsContext(1L, this.mJobServerContext));
        Assert.assertNull((Object)((BatchedJobDefinition.BatchedJobTask)((Pair)result.iterator().next()).getSecond()).getJobTaskArgs());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)workerInfo, (Object)((Pair)result.iterator().next()).getFirst());
    }
}

