/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan;

import alluxio.exception.ExceptionMessage;
import alluxio.exception.JobDoesNotExistException;
import alluxio.job.JobConfig;
import alluxio.job.TestPlanConfig;
import alluxio.job.plan.PlanConfig;
import alluxio.job.plan.PlanDefinition;
import alluxio.job.plan.PlanDefinitionRegistry;
import alluxio.job.plan.TestPlanDefinition;
import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class PlanDefinitionRegistryTest {
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Test
    public void getPlanDefinitionTest() throws Exception {
        PlanDefinition definition = PlanDefinitionRegistry.INSTANCE.getJobDefinition((JobConfig)new TestPlanConfig("test"));
        Assert.assertTrue((boolean)(definition instanceof TestPlanDefinition));
    }

    @Test
    public void getNonexistingPlanDefinitionTest() throws Exception {
        DummyPlanConfig planConfig = new DummyPlanConfig();
        this.mThrown.expect(JobDoesNotExistException.class);
        this.mThrown.expectMessage(ExceptionMessage.JOB_DEFINITION_DOES_NOT_EXIST.getMessage(new Object[]{planConfig.getName()}));
        PlanDefinitionRegistry.INSTANCE.getJobDefinition((JobConfig)planConfig);
    }

    class DummyPlanConfig
    implements PlanConfig {
        private static final long serialVersionUID = 1L;

        DummyPlanConfig() {
        }

        public String getName() {
            return "dummy";
        }

        public Collection<String> affectedPaths() {
            return Collections.EMPTY_LIST;
        }
    }
}

