/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan;

import alluxio.collections.Pair;
import alluxio.job.RunTaskContext;
import alluxio.job.SelectExecutorsContext;
import alluxio.job.SleepJobConfig;
import alluxio.job.plan.AbstractVoidPlanDefinition;
import alluxio.job.util.SerializableVoid;
import alluxio.util.CommonUtils;
import alluxio.wire.WorkerInfo;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public final class SleepPlanDefinition
extends AbstractVoidPlanDefinition<SleepJobConfig, SerializableVoid> {
    public Class<SleepJobConfig> getJobConfigClass() {
        return SleepJobConfig.class;
    }

    public Set<Pair<WorkerInfo, SerializableVoid>> selectExecutors(SleepJobConfig config, List<WorkerInfo> jobWorkerInfoList, SelectExecutorsContext selectExecutorsContext) throws Exception {
        Set<Pair<WorkerInfo, SerializableVoid>> executors = Collections.newSetFromMap(new IdentityHashMap());
        for (WorkerInfo jobWorker : jobWorkerInfoList) {
            for (int i = 0; i < config.getTasksPerWorker(); ++i) {
                executors.add((Pair<WorkerInfo, SerializableVoid>)new Pair((Object)jobWorker, null));
            }
        }
        return executors;
    }

    public SerializableVoid runTask(SleepJobConfig config, SerializableVoid args, RunTaskContext runTaskContext) throws Exception {
        CommonUtils.sleepMs((long)config.getTimeMs());
        return null;
    }
}

