/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.migrate;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.MockFileInStream;
import alluxio.client.file.MockFileOutStream;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.job.JobServerContext;
import alluxio.job.RunTaskContext;
import alluxio.job.plan.migrate.MigrateCommand;
import alluxio.job.plan.migrate.MigrateConfig;
import alluxio.job.plan.migrate.MigrateDefinition;
import alluxio.underfs.UfsManager;
import alluxio.util.io.BufferUtils;
import alluxio.wire.FileInfo;
import com.google.common.collect.Lists;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class MigrateDefinitionRunTaskTest {
    private static final String TEST_DIR = "/DIR";
    private static final String TEST_SOURCE = "/DIR/TEST_SOURCE";
    private static final String TEST_DESTINATION = "/DIR/TEST_DESTINATION";
    private static final byte[] TEST_SOURCE_CONTENTS = BufferUtils.getIncreasingByteArray((int)100);
    private FileSystem mMockFileSystem;
    private FileSystemContext mMockFileSystemContext;
    private MockFileInStream mMockInStream;
    private MockFileOutStream mMockOutStream;
    private UfsManager mMockUfsManager;

    @Before
    public void before() throws Exception {
        AlluxioConfiguration conf = Configuration.global();
        this.mMockFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        this.mMockFileSystemContext = (FileSystemContext)Mockito.mock(FileSystemContext.class);
        Mockito.when((Object)this.mMockFileSystemContext.getClientContext()).thenReturn((Object)ClientContext.create((AlluxioConfiguration)conf));
        Mockito.when((Object)this.mMockFileSystemContext.getClusterConf()).thenReturn((Object)conf);
        Mockito.when((Object)this.mMockFileSystemContext.getPathConf((AlluxioURI)ArgumentMatchers.any(AlluxioURI.class))).thenReturn((Object)conf);
        this.mMockInStream = new MockFileInStream(TEST_SOURCE_CONTENTS);
        Mockito.when((Object)this.mMockFileSystem.openFile((AlluxioURI)ArgumentMatchers.eq((Object)new AlluxioURI(TEST_SOURCE)), (OpenFilePOptions)ArgumentMatchers.any(OpenFilePOptions.class))).thenReturn((Object)this.mMockInStream);
        this.mMockOutStream = new MockFileOutStream(this.mMockFileSystemContext);
        Mockito.when((Object)this.mMockFileSystem.createFile((AlluxioURI)ArgumentMatchers.eq((Object)new AlluxioURI(TEST_DESTINATION)), (CreateFilePOptions)ArgumentMatchers.any(CreateFilePOptions.class))).thenReturn((Object)this.mMockOutStream);
        this.mMockUfsManager = (UfsManager)Mockito.mock(UfsManager.class);
    }

    @Test
    public void basicMigrateTest() throws Exception {
        this.runTask(TEST_SOURCE, TEST_SOURCE, TEST_DESTINATION, WriteType.THROUGH);
        Assert.assertArrayEquals((byte[])TEST_SOURCE_CONTENTS, (byte[])this.mMockOutStream.toByteArray());
    }

    @Test
    public void deleteEmptySourceDir() throws Exception {
        Mockito.when((Object)this.mMockFileSystem.listStatus(new AlluxioURI(TEST_DIR))).thenReturn((Object)Lists.newArrayList());
        this.runTask(TEST_DIR, TEST_SOURCE, TEST_DESTINATION, WriteType.THROUGH);
    }

    @Test
    public void deleteDirsOnlySourceDir() throws Exception {
        String inner = "/DIR/innerDir";
        Mockito.when((Object)this.mMockFileSystem.listStatus(new AlluxioURI(TEST_DIR))).thenReturn((Object)Lists.newArrayList((Object[])new URIStatus[]{new URIStatus(new FileInfo().setPath(inner).setFolder(true))}));
        Mockito.when((Object)this.mMockFileSystem.listStatus(new AlluxioURI(inner))).thenReturn((Object)Lists.newArrayList());
        this.runTask(TEST_DIR, TEST_SOURCE, TEST_DESTINATION, WriteType.THROUGH);
    }

    @Test
    public void dontDeleteNonEmptySourceTest() throws Exception {
        Mockito.when((Object)this.mMockFileSystem.listStatus(new AlluxioURI(TEST_DIR))).thenReturn((Object)Lists.newArrayList((Object[])new URIStatus[]{new URIStatus(new FileInfo())}));
        this.runTask(TEST_DIR, TEST_SOURCE, TEST_DESTINATION, WriteType.THROUGH);
        ((FileSystem)Mockito.verify((Object)this.mMockFileSystem, (VerificationMode)Mockito.never())).delete((AlluxioURI)ArgumentMatchers.eq((Object)new AlluxioURI(TEST_DIR)), (DeletePOptions)ArgumentMatchers.any(DeletePOptions.class));
    }

    @Test
    public void writeTypeTest() throws Exception {
        this.runTask(TEST_SOURCE, TEST_SOURCE, TEST_DESTINATION, WriteType.CACHE_THROUGH);
        ((FileSystem)Mockito.verify((Object)this.mMockFileSystem)).createFile((AlluxioURI)ArgumentMatchers.eq((Object)new AlluxioURI(TEST_DESTINATION)), (CreateFilePOptions)ArgumentMatchers.eq((Object)CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build()));
        this.runTask(TEST_SOURCE, TEST_SOURCE, TEST_DESTINATION, WriteType.MUST_CACHE);
        ((FileSystem)Mockito.verify((Object)this.mMockFileSystem)).createFile((AlluxioURI)ArgumentMatchers.eq((Object)new AlluxioURI(TEST_DESTINATION)), (CreateFilePOptions)ArgumentMatchers.eq((Object)CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build()));
    }

    @Test
    public void writeTypeAsyncThroughPersistedTest() throws Exception {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setPersisted(true);
        Mockito.when((Object)this.mMockFileSystem.getStatus((AlluxioURI)ArgumentMatchers.eq((Object)new AlluxioURI(TEST_SOURCE)))).thenReturn((Object)new URIStatus(fileInfo));
        this.runTask(TEST_SOURCE, TEST_SOURCE, TEST_DESTINATION, WriteType.ASYNC_THROUGH);
    }

    @Test
    public void overwriteFailureTest() throws Exception {
        AtomicBoolean deleteCalled = new AtomicBoolean(false);
        Mockito.when((Object)this.mMockFileSystem.createFile((AlluxioURI)ArgumentMatchers.eq((Object)new AlluxioURI(TEST_DESTINATION)), (CreateFilePOptions)ArgumentMatchers.any())).thenAnswer(invocation -> {
            if (deleteCalled.get()) {
                return this.mMockOutStream;
            }
            throw new FileAlreadyExistsException("already exists");
        });
        try {
            this.runTask(TEST_SOURCE, TEST_SOURCE, TEST_DESTINATION, WriteType.THROUGH, false);
            TestCase.fail();
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void overwriteSuccessTest() throws Exception {
        AtomicBoolean deleteCalled = new AtomicBoolean(false);
        Mockito.when((Object)this.mMockFileSystem.createFile((AlluxioURI)ArgumentMatchers.any(AlluxioURI.class), (CreateFilePOptions)ArgumentMatchers.any())).thenAnswer(invocation -> {
            if (deleteCalled.get()) {
                return this.mMockOutStream;
            }
            deleteCalled.set(true);
            throw new FileAlreadyExistsException("already exists");
        });
        this.runTask(TEST_SOURCE, TEST_SOURCE, TEST_DESTINATION, WriteType.THROUGH, true);
        ((FileSystem)Mockito.verify((Object)this.mMockFileSystem)).delete((AlluxioURI)ArgumentMatchers.eq((Object)new AlluxioURI(TEST_DESTINATION)));
        ((FileSystem)Mockito.verify((Object)this.mMockFileSystem)).rename((AlluxioURI)ArgumentMatchers.any(AlluxioURI.class), (AlluxioURI)ArgumentMatchers.eq((Object)new AlluxioURI(TEST_DESTINATION)));
    }

    private void runTask(String configSource, String commandSource, String commandDestination, WriteType writeType) throws Exception {
        this.runTask(configSource, commandSource, commandDestination, writeType, false);
    }

    private void runTask(String configSource, String commandSource, String commandDestination, WriteType writeType, boolean overwrite) throws Exception {
        new MigrateDefinition().runTask(new MigrateConfig(configSource, "", writeType, overwrite), new MigrateCommand(commandSource, commandDestination), new RunTaskContext(1L, 1L, new JobServerContext(this.mMockFileSystem, this.mMockFileSystemContext, this.mMockUfsManager)));
    }
}

