/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.migrate;

import alluxio.AlluxioURI;
import alluxio.client.WriteType;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.URIStatus;
import alluxio.collections.Pair;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileDoesNotExistException;
import alluxio.job.JobServerContext;
import alluxio.job.SelectExecutorsContext;
import alluxio.job.plan.SelectExecutorsTest;
import alluxio.job.plan.migrate.MigrateCommand;
import alluxio.job.plan.migrate.MigrateConfig;
import alluxio.job.plan.migrate.MigrateDefinition;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.FileInfo;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class MigrateDefinitionSelectExecutorsTest
extends SelectExecutorsTest {
    private static final List<BlockWorkerInfo> BLOCK_WORKERS = new ImmutableList.Builder().add((Object)new BlockWorkerInfo(new WorkerNetAddress().setHost("host0"), 0L, 0L)).add((Object)new BlockWorkerInfo(new WorkerNetAddress().setHost("host1"), 0L, 0L)).add((Object)new BlockWorkerInfo(new WorkerNetAddress().setHost("host2"), 0L, 0L)).add((Object)new BlockWorkerInfo(new WorkerNetAddress().setHost("host3"), 0L, 0L)).build();

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        Mockito.when((Object)this.mMockFileSystemContext.getCachedWorkers()).thenReturn(BLOCK_WORKERS);
        this.createDirectory("/");
    }

    @Test
    public void migrateToSelf() throws Exception {
        this.createDirectory("/src");
        Assert.assertEquals((Object)ImmutableSet.of(), this.assignMigrates("/src", "/src"));
    }

    @Test
    public void assignToLocalWorker() throws Exception {
        this.createFileWithBlocksOnWorkers("/src", 0);
        this.setPathToNotExist("/dst");
        ImmutableSet expected = ImmutableSet.of((Object)new Pair(JOB_WORKERS.get(0), (Object)new MigrateCommand("/src", "/dst")));
        Assert.assertEquals((Object)expected, this.assignMigrates("/src", "/dst"));
    }

    @Test
    public void assignToWorkerWithMostBlocks() throws Exception {
        this.createFileWithBlocksOnWorkers("/src", 3, 1, 1, 3, 1);
        this.setPathToNotExist("/dst");
        ImmutableSet expected = ImmutableSet.of((Object)new Pair(JOB_WORKERS.get(1), (Object)new MigrateCommand("/src", "/dst")));
        Assert.assertEquals((Object)expected, this.assignMigrates("/src", "/dst"));
    }

    @Test
    public void migrateToSubpath() throws Exception {
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.assignMigratesFail("/src", "/src/dst"));
        Assert.assertEquals((Object)ExceptionMessage.MIGRATE_CANNOT_BE_TO_SUBDIRECTORY.getMessage(new Object[]{"/src", "/src/dst"}), (Object)exception.getMessage());
    }

    @Test
    public void migrateMissingSource() throws Exception {
        this.setPathToNotExist("/notExist");
        FileDoesNotExistException exception = (FileDoesNotExistException)Assert.assertThrows(FileDoesNotExistException.class, () -> this.assignMigratesFail("/notExist", "/dst"));
        Assert.assertEquals((Object)ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{"/notExist"}), (Object)exception.getMessage());
    }

    @Test
    public void migrateUncachedFile() throws Exception {
        this.createFileWithBlocksOnWorkers("/src", new int[0]);
        this.setPathToNotExist("/dst");
        Assert.assertEquals((long)1L, (long)this.assignMigrates("/src", "/dst").size());
    }

    @Test
    public void migrateNoLocalJobWorker() throws Exception {
        this.createFileWithBlocksOnWorkers("/src", 0);
        this.setPathToNotExist("/dst");
        Set assignments = new MigrateDefinition().selectExecutors(new MigrateConfig("/src", "/dst", WriteType.THROUGH, true), (List)ImmutableList.of((Object)JOB_WORKER_3), new SelectExecutorsContext(1L, new JobServerContext(this.mMockFileSystem, this.mMockFileSystemContext, this.mMockUfsManager)));
        Assert.assertEquals((Object)ImmutableSet.of((Object)new Pair((Object)JOB_WORKER_3, (Object)new MigrateCommand("/src", "/dst"))), (Object)assignments);
    }

    private Set<Pair<WorkerInfo, MigrateCommand>> assignMigrates(String source, String destination) throws Exception {
        return this.assignMigrates(new MigrateConfig(source, destination, WriteType.THROUGH, false));
    }

    private Set<Pair<WorkerInfo, MigrateCommand>> assignMigrates(MigrateConfig config) throws Exception {
        return new MigrateDefinition().selectExecutors(config, JOB_WORKERS, new SelectExecutorsContext(1L, new JobServerContext(this.mMockFileSystem, this.mMockFileSystemContext, this.mMockUfsManager)));
    }

    private void assignMigratesFail(String source, String destination) throws Exception {
        this.assignMigratesFail(source, destination, WriteType.THROUGH, false);
    }

    private void assignMigratesFail(String source, String destination, WriteType writeType, boolean overwrite) throws Exception {
        Set<Pair<WorkerInfo, MigrateCommand>> assignment = this.assignMigrates(new MigrateConfig(source, destination, writeType, overwrite));
        Assert.fail((String)("Selecting executors should have failed, but it succeeded with assignment " + assignment));
    }

    private FileInfo createFileWithBlocksOnWorkers(String testFile, int ... workerInds) throws Exception {
        return this.createFileWithBlocksOnWorkers(testFile, new FileInfo(), workerInds);
    }

    private FileInfo createFileWithBlocksOnWorkers(String testFile, FileInfo fileInfo, int ... workerInds) throws Exception {
        AlluxioURI uri = new AlluxioURI(testFile);
        ArrayList blockInfos = Lists.newArrayList();
        for (int workerInd : workerInds) {
            WorkerNetAddress address = ((WorkerInfo)JOB_WORKERS.get(workerInd)).getAddress();
            blockInfos.add(new FileBlockInfo().setBlockInfo(new BlockInfo().setLocations((List)Lists.newArrayList((Object[])new BlockLocation[]{new BlockLocation().setWorkerAddress(address)}))));
        }
        FileInfo testFileInfo = fileInfo.setFolder(false).setPath(testFile).setFileBlockInfos((List)blockInfos);
        Mockito.when((Object)this.mMockFileSystem.listStatus(uri)).thenReturn((Object)Lists.newArrayList((Object[])new URIStatus[]{new URIStatus(testFileInfo)}));
        Mockito.when((Object)this.mMockFileSystem.getStatus(uri)).thenReturn((Object)new URIStatus(testFileInfo));
        return testFileInfo;
    }

    private FileInfo createDirectory(String name) throws Exception {
        FileInfo info = new FileInfo().setFolder(true).setPath(name).setMountPoint(true);
        Mockito.when((Object)this.mMockFileSystem.getStatus(new AlluxioURI(name))).thenReturn((Object)new URIStatus(info));
        return info;
    }

    private void setPathToNotExist(String path) throws Exception {
        AlluxioURI uri = new AlluxioURI(path);
        Mockito.when((Object)this.mMockFileSystem.getStatus(uri)).thenThrow(new Throwable[]{new FileDoesNotExistException(uri)});
        Mockito.when((Object)this.mMockFileSystem.listStatus(uri)).thenThrow(new Throwable[]{new FileDoesNotExistException(uri)});
    }
}

