/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.persist;

import alluxio.AlluxioURI;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.collections.Pair;
import alluxio.job.JobServerContext;
import alluxio.job.SelectExecutorsContext;
import alluxio.job.plan.persist.PersistConfig;
import alluxio.job.plan.persist.PersistDefinition;
import alluxio.underfs.UfsManager;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.FileInfo;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class PersistDefinitionTest {
    private FileSystem mMockFileSystem;
    private FileSystemContext mMockFileSystemContext;
    private JobServerContext mJobServerContext;

    @Before
    public void before() {
        this.mMockFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        this.mMockFileSystemContext = (FileSystemContext)Mockito.mock(FileSystemContext.class);
        this.mJobServerContext = new JobServerContext(this.mMockFileSystem, this.mMockFileSystemContext, (UfsManager)Mockito.mock(UfsManager.class));
    }

    @Test
    public void selectExecutorsTest() throws Exception {
        AlluxioURI uri = new AlluxioURI("/test");
        PersistConfig config = new PersistConfig(uri.getPath(), -1L, true, "");
        WorkerNetAddress workerNetAddress1 = new WorkerNetAddress().setDataPort(10).setHost("host1");
        WorkerNetAddress workerNetAddress2 = new WorkerNetAddress().setDataPort(100).setHost("host2");
        BlockWorkerInfo blockWorkerInfo1 = new BlockWorkerInfo(workerNetAddress1, 1L, 1L);
        BlockWorkerInfo blockWorkerInfo2 = new BlockWorkerInfo(workerNetAddress2, 1L, 1L);
        WorkerInfo workerInfo1 = new WorkerInfo().setAddress(workerNetAddress1);
        WorkerInfo workerInfo2 = new WorkerInfo().setAddress(workerNetAddress2);
        FileBlockInfo fileBlockInfo1 = this.mockFileBlockInfo(1L, workerNetAddress2);
        FileBlockInfo fileBlockInfo2 = this.mockFileBlockInfo(2L, workerNetAddress1);
        FileBlockInfo fileBlockInfo3 = this.mockFileBlockInfo(3L, workerNetAddress1);
        FileInfo testFileInfo = new FileInfo();
        testFileInfo.setFileBlockInfos((List)Lists.newArrayList((Object[])new FileBlockInfo[]{fileBlockInfo1, fileBlockInfo2, fileBlockInfo3}));
        Mockito.when((Object)this.mMockFileSystemContext.getCachedWorkers()).thenReturn((Object)Lists.newArrayList((Object[])new BlockWorkerInfo[]{blockWorkerInfo1, blockWorkerInfo2}));
        Mockito.when((Object)this.mMockFileSystem.getStatus(uri)).thenReturn((Object)new URIStatus(testFileInfo));
        Set result = new PersistDefinition().selectExecutors(config, (List)Lists.newArrayList((Object[])new WorkerInfo[]{workerInfo2, workerInfo1}), new SelectExecutorsContext(1L, this.mJobServerContext));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)workerInfo1, (Object)((Pair)result.iterator().next()).getFirst());
    }

    private FileBlockInfo mockFileBlockInfo(long blockId, WorkerNetAddress workerNetAddress) {
        BlockInfo blockInfo = new BlockInfo().setBlockId(blockId);
        FileBlockInfo fileBlockInfo = new FileBlockInfo().setBlockInfo(blockInfo);
        BlockLocation location = new BlockLocation();
        location.setWorkerAddress(workerNetAddress);
        blockInfo.setLocations((List)Lists.newArrayList((Object[])new BlockLocation[]{location}));
        return fileBlockInfo;
    }
}

