/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.replicate;

import alluxio.client.block.BlockStoreClient;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.collections.Pair;
import alluxio.job.JobServerContext;
import alluxio.job.SelectExecutorsContext;
import alluxio.job.plan.replicate.Mode;
import alluxio.job.plan.replicate.SetReplicaConfig;
import alluxio.job.plan.replicate.SetReplicaDefinition;
import alluxio.job.plan.replicate.SetReplicaTask;
import alluxio.job.util.SerializableVoid;
import alluxio.underfs.UfsManager;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.beust.jcommander.internal.Sets;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public final class SetReplicaDefinitionEvictTest {
    private static final long TEST_BLOCK_ID = 1L;
    private static final WorkerNetAddress ADDRESS_1 = new WorkerNetAddress().setHost("host1").setDataPort(10);
    private static final WorkerNetAddress ADDRESS_2 = new WorkerNetAddress().setHost("host2").setDataPort(10);
    private static final WorkerNetAddress ADDRESS_3 = new WorkerNetAddress().setHost("host3").setDataPort(10);
    private static final WorkerInfo WORKER_INFO_1 = new WorkerInfo().setAddress(ADDRESS_1);
    private static final WorkerInfo WORKER_INFO_2 = new WorkerInfo().setAddress(ADDRESS_2);
    private static final WorkerInfo WORKER_INFO_3 = new WorkerInfo().setAddress(ADDRESS_3);
    private static final Set<Pair<WorkerInfo, SerializableVoid>> EMPTY = Sets.newHashSet();
    private FileSystem mMockFileSystem;
    private FileSystemContext mMockFileSystemContext;
    private BlockStoreClient mMockBlockStore;
    private JobServerContext mJobServerContext;
    private MockedStatic<BlockStoreClient> mMockStaticBlockStore;

    @Before
    public void before() {
        this.mMockFileSystemContext = (FileSystemContext)Mockito.mock(FileSystemContext.class);
        this.mMockFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        this.mMockBlockStore = (BlockStoreClient)Mockito.mock(BlockStoreClient.class);
        this.mJobServerContext = new JobServerContext(this.mMockFileSystem, this.mMockFileSystemContext, (UfsManager)Mockito.mock(UfsManager.class));
        this.mMockStaticBlockStore = Mockito.mockStatic(BlockStoreClient.class);
        this.mMockStaticBlockStore.when(() -> BlockStoreClient.create((FileSystemContext)this.mMockFileSystemContext)).thenReturn((Object)this.mMockBlockStore);
    }

    @After
    public void after() {
        this.mMockStaticBlockStore.close();
    }

    private Set<Pair<WorkerInfo, SetReplicaTask>> selectExecutorsTestHelper(List<BlockLocation> blockLocations, int replicas, List<WorkerInfo> workerInfoList) throws Exception {
        BlockInfo blockInfo = new BlockInfo().setBlockId(1L);
        blockInfo.setLocations(blockLocations);
        Mockito.when((Object)this.mMockBlockStore.getInfo(1L)).thenReturn((Object)blockInfo);
        SetReplicaConfig config = new SetReplicaConfig("", 1L, replicas);
        SetReplicaDefinition definition = new SetReplicaDefinition();
        return definition.selectExecutors(config, workerInfoList, new SelectExecutorsContext(1L, this.mJobServerContext));
    }

    @Test
    public void selectExecutorsNoBlockWorkerHasBlock() throws Exception {
        Set<Pair<WorkerInfo, SetReplicaTask>> result = this.selectExecutorsTestHelper(Lists.newArrayList(), 0, Lists.newArrayList((Object[])new WorkerInfo[]{WORKER_INFO_1, WORKER_INFO_2, WORKER_INFO_3}));
        Assert.assertEquals(EMPTY, result);
    }

    @Test
    public void selectExecutorsNoJobWorkerHasBlock() throws Exception {
        Set<Pair<WorkerInfo, SetReplicaTask>> result = this.selectExecutorsTestHelper(Lists.newArrayList((Object[])new BlockLocation[]{new BlockLocation().setWorkerAddress(ADDRESS_1)}), 0, Lists.newArrayList((Object[])new WorkerInfo[]{WORKER_INFO_2, WORKER_INFO_3}));
        Assert.assertEquals(EMPTY, result);
    }

    @Test
    public void selectExecutorsOnlyOneBlockWorkerHasBlock() throws Exception {
        Set<Pair<WorkerInfo, SetReplicaTask>> result = this.selectExecutorsTestHelper(Lists.newArrayList((Object[])new BlockLocation[]{new BlockLocation().setWorkerAddress(ADDRESS_1)}), 0, Lists.newArrayList((Object[])new WorkerInfo[]{WORKER_INFO_1, WORKER_INFO_2, WORKER_INFO_3}));
        Set expected = Sets.newHashSet();
        expected.add(new Pair((Object)WORKER_INFO_1, (Object)new SetReplicaTask(Mode.EVICT)));
        Assert.assertEquals((Object)expected, result);
    }

    @Test
    public void selectExecutorsAnyOneWorkers() throws Exception {
        Set<Pair<WorkerInfo, SetReplicaTask>> result = this.selectExecutorsTestHelper(Lists.newArrayList((Object[])new BlockLocation[]{new BlockLocation().setWorkerAddress(ADDRESS_1), new BlockLocation().setWorkerAddress(ADDRESS_2), new BlockLocation().setWorkerAddress(ADDRESS_3)}), 2, Lists.newArrayList((Object[])new WorkerInfo[]{WORKER_INFO_1, WORKER_INFO_2, WORKER_INFO_3}));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)new SetReplicaTask(Mode.EVICT), (Object)result.iterator().next().getSecond());
    }

    @Test
    public void selectExecutorsAllWorkers() throws Exception {
        Set<Pair<WorkerInfo, SetReplicaTask>> result = this.selectExecutorsTestHelper(Lists.newArrayList((Object[])new BlockLocation[]{new BlockLocation().setWorkerAddress(ADDRESS_1), new BlockLocation().setWorkerAddress(ADDRESS_2), new BlockLocation().setWorkerAddress(ADDRESS_3)}), 0, Lists.newArrayList((Object[])new WorkerInfo[]{WORKER_INFO_1, WORKER_INFO_2, WORKER_INFO_3}));
        Set expected = Sets.newHashSet();
        expected.add(new Pair((Object)WORKER_INFO_1, (Object)new SetReplicaTask(Mode.EVICT)));
        expected.add(new Pair((Object)WORKER_INFO_2, (Object)new SetReplicaTask(Mode.EVICT)));
        expected.add(new Pair((Object)WORKER_INFO_3, (Object)new SetReplicaTask(Mode.EVICT)));
        Assert.assertEquals((Object)expected, result);
    }

    @Test
    public void selectExecutorsBothWorkers() throws Exception {
        Set<Pair<WorkerInfo, SetReplicaTask>> result = this.selectExecutorsTestHelper(Lists.newArrayList((Object[])new BlockLocation[]{new BlockLocation().setWorkerAddress(ADDRESS_1), new BlockLocation().setWorkerAddress(ADDRESS_2)}), 0, Lists.newArrayList((Object[])new WorkerInfo[]{WORKER_INFO_1, WORKER_INFO_2, WORKER_INFO_3}));
        Set expected = Sets.newHashSet();
        expected.add(new Pair((Object)WORKER_INFO_1, (Object)new SetReplicaTask(Mode.EVICT)));
        expected.add(new Pair((Object)WORKER_INFO_2, (Object)new SetReplicaTask(Mode.EVICT)));
        Assert.assertEquals((Object)expected, result);
    }

    @Test
    public void selectExecutorsTargetEqualNumBlocks() throws Exception {
        Set<Pair<WorkerInfo, SetReplicaTask>> result = this.selectExecutorsTestHelper(Lists.newArrayList((Object[])new BlockLocation[]{new BlockLocation().setWorkerAddress(ADDRESS_1)}), 1, Lists.newArrayList((Object[])new WorkerInfo[]{WORKER_INFO_1, WORKER_INFO_2, WORKER_INFO_3}));
        Assert.assertEquals(EMPTY, result);
    }
}

